/*
 * Copyright 2007 Fred Sauer
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.allen_sauer.gwt.dragdrop.client.util;

/**
 * A position represented by a left (x) and top (y) coordinate.
 */
public class CoordinateLocation extends AbstractLocation {

  private int left;
  private int top;

  public CoordinateLocation(int left, int top) {
    this.left = left;
    this.top = top;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.allen_sauer.gwt.dragdrop.client.util.Location#getLeft()
   */
  public int getLeft() {
    return left;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.allen_sauer.gwt.dragdrop.client.util.Location#getTop()
   */
  public int getTop() {
    return top;
  }
}
