/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.watcher.jnotify;

import com.google.code.play2.watcher.api.AbstractFileWatchService;
import com.google.code.play2.watcher.api.FileWatchCallback;
import com.google.code.play2.watcher.api.FileWatchException;
import com.google.code.play2.watcher.api.FileWatchLogger;
import com.google.code.play2.watcher.api.FileWatchService;
import com.google.code.play2.watcher.api.FileWatcher;
import com.google.code.play2.watcher.jnotify.JNotifyFileWatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyException;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileWatchService.class, hint="jnotify", description="JNotify")
public class JNotifyFileWatchService
extends AbstractFileWatchService {
    public void initialize(FileWatchLogger log) throws FileWatchException {
        super.initialize(log);
        File nativeLibsDirectory = new File(".");
        String nativeLibsDirectoryProp = System.getProperty("play2.nativeLibsDirectory");
        if (nativeLibsDirectoryProp != null && !"".equals(nativeLibsDirectoryProp)) {
            nativeLibsDirectory = new File(nativeLibsDirectoryProp);
        } else {
            String targetDirectoryProp = System.getProperty("project.build.directory");
            if (targetDirectoryProp != null && !"".equals(targetDirectoryProp)) {
                File targetDirectory = new File(targetDirectoryProp);
                nativeLibsDirectory = new File(targetDirectory, "native_libraries");
            }
        }
        String nativeLibsPath = nativeLibsDirectory.getAbsolutePath();
        if (!nativeLibsDirectory.exists() && !nativeLibsDirectory.mkdirs()) {
            throw new FileWatchException(String.format("Cannot create \"%s\" directory", nativeLibsPath));
        }
        String libraryOS = null;
        String libraryName = "jnotify";
        String osName = System.getProperty("os.name");
        if (osName != null) {
            osName = osName.toLowerCase(Locale.ENGLISH);
            String architecture = System.getProperty("sun.arch.data.model");
            if (osName.startsWith("windows")) {
                libraryOS = "windows" + architecture;
                if ("amd64".equals(System.getProperty("os.arch"))) {
                    libraryName = "jnotify_64bit";
                }
            } else if (osName.equals("linux")) {
                libraryOS = "linux" + architecture;
            } else if (osName.startsWith("mac os x")) {
                libraryOS = "osx";
            }
        }
        if (libraryOS == null) {
            throw new FileWatchException(String.format("JNotifyFileWatchService initialization failed - unsupported OS \"%s\"", osName));
        }
        String libraryResourceName = System.mapLibraryName(libraryName);
        File outputFile = new File(nativeLibsDirectory, libraryResourceName = libraryResourceName.replace(".dylib", ".jnilib"));
        if (!outputFile.exists()) {
            try {
                this.copyResourceToFile("META-INF/native/" + libraryOS, libraryResourceName, nativeLibsDirectory);
            }
            catch (IOException e) {
                throw new FileWatchException("JNotifyFileWatchService initialization failed", (Throwable)e);
            }
        }
        try {
            String javaLibraryPath = System.getProperty("java.library.path");
            javaLibraryPath = javaLibraryPath != null ? javaLibraryPath + File.pathSeparator + nativeLibsPath : nativeLibsPath;
            System.setProperty("java.library.path", javaLibraryPath);
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (Exception e) {
            throw new FileWatchException("JNotifyFileWatchService initialization failed", (Throwable)e);
        }
        try {
            JNotify.removeWatch((int)0);
        }
        catch (JNotifyException e) {
            throw new FileWatchException("JNotifyFileWatchService initialization failed", (Throwable)e);
        }
    }

    public FileWatcher watch(List<File> filesToWatch, FileWatchCallback watchCallback) throws FileWatchException {
        try {
            return new JNotifyFileWatcher(this.log, filesToWatch, watchCallback);
        }
        catch (JNotifyException e) {
            throw new FileWatchException("JNotifyFileWatcher initialization failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToFile(String resourcePath, String libraryName, File outputDirectory) throws IOException, FileWatchException {
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath + "/" + libraryName);
        if (is == null) {
            throw new FileWatchException("JNotifyFileWatcherService initialization failed, native library resource \"" + resourcePath + "/" + libraryName + "\" not found");
        }
        try {
            byte[] buffer = new byte[8192];
            int len = is.read(buffer);
            File outputFile = new File(outputDirectory, libraryName);
            FileOutputStream os = new FileOutputStream(outputFile);
            try {
                while (len != -1) {
                    ((OutputStream)os).write(buffer, 0, len);
                    len = is.read(buffer);
                }
            }
            finally {
                os.flush();
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
    }
}

