/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.watcher.jnotify;

import com.google.code.play2.watcher.api.AbstractFileWatcher;
import com.google.code.play2.watcher.api.FileWatchCallback;
import com.google.code.play2.watcher.api.FileWatchLogger;
import java.io.File;
import java.util.List;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;

public class JNotifyFileWatcher
extends AbstractFileWatcher
implements JNotifyListener {
    private int[] registeredWatchIds;

    public JNotifyFileWatcher(FileWatchLogger log, List<File> dirsToWatch, FileWatchCallback watchCallback) throws JNotifyException {
        super(log, watchCallback);
        this.registeredWatchIds = new int[dirsToWatch.size()];
        for (int i = 0; i < dirsToWatch.size(); ++i) {
            int watchId;
            File file = dirsToWatch.get(i);
            this.registeredWatchIds[i] = watchId = JNotify.addWatch((String)file.getAbsolutePath(), (int)15, (boolean)true, (JNotifyListener)this);
            this.debug("[jnotify] Watch %d added for \"%s\"", watchId, file.getAbsolutePath());
        }
    }

    public void fileCreated(int wd, String rootPath, String name) {
        this.debug("[jnotify] File created \"%s\", \"%s\"", rootPath, name);
        this.watchCallback.onChange(new File(rootPath, name));
    }

    public void fileDeleted(int wd, String rootPath, String name) {
        this.debug("[jnotify] File deleted \"%s\", \"%s\"", rootPath, name);
        this.watchCallback.onChange(new File(rootPath, name));
    }

    public void fileModified(int wd, String rootPath, String name) {
        this.debug("[jnotify] File modified \"%s\", \"%s\"", rootPath, name);
        this.watchCallback.onChange(new File(rootPath, name));
    }

    public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
        this.debug("[jnotify] File renamed \"%s\", \"%s\" -> \"%s\"", rootPath, oldName, newName);
        this.watchCallback.onChange(new File(rootPath, oldName));
        this.watchCallback.onChange(new File(rootPath, newName));
    }

    public void close() {
        for (int i = 0; i < this.registeredWatchIds.length; ++i) {
            int watchId = this.registeredWatchIds[i];
            if (watchId <= 0) continue;
            try {
                JNotify.removeWatch((int)watchId);
                this.debug("[jnotify] Watch %d removed", watchId);
                continue;
            }
            catch (JNotifyException e) {
                this.debug("[jnotify] Cannot remove watch %d, ignored.", this.registeredWatchIds[i]);
            }
        }
    }

    private void debug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(message, args));
        }
    }
}

