/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.watcher.polling;

import com.google.code.play2.watcher.api.AbstractFileWatchService;
import com.google.code.play2.watcher.api.FileWatchCallback;
import com.google.code.play2.watcher.api.FileWatchException;
import com.google.code.play2.watcher.api.FileWatchLogger;
import com.google.code.play2.watcher.api.FileWatchService;
import com.google.code.play2.watcher.api.FileWatcher;
import com.google.code.play2.watcher.polling.PollingFileWatcher;
import java.io.File;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileWatchService.class, hint="polling", description="Polling")
public class PollingFileWatchService
extends AbstractFileWatchService {
    private final int DEFAULT_POLL_INTERVAL = 1000;
    private int pollInterval;

    public void initialize(FileWatchLogger log) throws FileWatchException {
        super.initialize(log);
        this.pollInterval = 1000;
        String pollIntervalProp = System.getProperty("play2.pollInterval");
        if (pollIntervalProp != null) {
            try {
                this.pollInterval = Integer.parseInt(pollIntervalProp);
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Unparsable property value \"%s\", using default poll interval %d ms", pollIntervalProp, 1000));
            }
        }
    }

    public FileWatcher watch(List<File> filesToWatch, FileWatchCallback watchCallback) {
        PollingFileWatcher result = new PollingFileWatcher(this.log, filesToWatch, watchCallback, this.pollInterval);
        Thread thread = new Thread((Runnable)result, "polling-play-watch-service");
        thread.setDaemon(true);
        thread.start();
        return result;
    }
}

