/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.watcher.polling;

import com.google.code.play2.watcher.api.AbstractFileWatcher;
import com.google.code.play2.watcher.api.FileWatchCallback;
import com.google.code.play2.watcher.api.FileWatchLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PollingFileWatcher
extends AbstractFileWatcher
implements Runnable {
    private final List<File> dirsToWatch;
    private final int pollDelayMillis;
    private boolean closed;
    private Map<String, Long> previousFileTimestamps = null;

    public PollingFileWatcher(FileWatchLogger log, List<File> dirsToWatch, FileWatchCallback watchCallback, int pollDelayMillis) {
        super(log, watchCallback);
        this.dirsToWatch = dirsToWatch;
        this.pollDelayMillis = pollDelayMillis;
    }

    public synchronized void close() {
        this.closed = true;
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public void run() {
        while (!this.isClosed()) {
            this.watch();
            try {
                Thread.sleep(this.pollDelayMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void watch() {
        Map<String, Long> currentFileTimestamps = this.allFileTimestamps(this.dirsToWatch);
        if (this.previousFileTimestamps != null) {
            HashSet<String> currentPaths = new HashSet<String>(currentFileTimestamps.keySet());
            for (Map.Entry<String, Long> previousEntry : this.previousFileTimestamps.entrySet()) {
                String path = previousEntry.getKey();
                Long prevTimeStamp = previousEntry.getValue();
                Long currentTimestamp = currentFileTimestamps.get(path);
                if (currentTimestamp != null) {
                    if (!currentTimestamp.equals(prevTimeStamp)) {
                        this.debug("[polling] File modified \"%s\"", path);
                        this.watchCallback.onChange(new File(path));
                    }
                    currentPaths.remove(path);
                    continue;
                }
                this.debug("[polling] File deleted \"%s\"", path);
                this.watchCallback.onChange(new File(path));
            }
            for (String path : currentPaths) {
                this.debug("[polling] File created \"%s\"", path);
                this.watchCallback.onChange(new File(path));
            }
        }
        this.previousFileTimestamps = currentFileTimestamps;
    }

    private Map<String, Long> allFileTimestamps(List<File> dirs) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        ArrayList<String> processedDirs = new ArrayList<String>();
        for (File dir : dirs) {
            this.internalAllFileTimestamps(dir, processedDirs, result);
        }
        return result;
    }

    private void internalAllFileTimestamps(File dir, List<String> processedDirs, Map<String, Long> result) {
        if (!processedDirs.contains(dir)) {
            processedDirs.add(dir.getAbsolutePath());
            for (File file : dir.listFiles()) {
                if (file.isFile()) {
                    result.put(file.getAbsolutePath(), file.lastModified());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.internalAllFileTimestamps(file, processedDirs, result);
            }
        }
    }

    private void debug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(message, args));
        }
    }
}

