/*
 * Copyright 2013-2016 Grzegorz Slowikowski (gslowikowski at gmail dot com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.google.code.sbt.compiler.sbt012;

import java.io.File;

import com.typesafe.zinc.Compiler$;

import com.google.code.sbt.compiler.api.Analysis;
import com.google.code.sbt.compiler.api.AnalysisProcessor;

import org.codehaus.plexus.component.annotations.Component;

/**
 * SBT 0.12.x compatible analysis processor
 * 
 * @author <a href="mailto:gslowikowski@gmail.com">Grzegorz Slowikowski</a>
 */
@Component( role = AnalysisProcessor.class, hint = "sbt012", description = "SBT 0.12.x analysis processor" )
public class SBT012AnalysisProcessor
    implements AnalysisProcessor
{
    /**
     * {@inheritDoc}
     */
    @Override
    public boolean areClassFileTimestampsSupported()
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Analysis readFromFile( File analysisCacheFile )
    {
        return new SBT012Analysis( Compiler$.MODULE$.analysis( analysisCacheFile ) );
    }

}
