/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.sbt012;

import com.google.code.sbt.compiler.api.AbstractCompiler;
import com.google.code.sbt.compiler.api.Analysis;
import com.google.code.sbt.compiler.api.CompilationProblem;
import com.google.code.sbt.compiler.api.CompilerConfiguration;
import com.google.code.sbt.compiler.api.CompilerException;
import com.google.code.sbt.compiler.api.CompilerLogger;
import com.google.code.sbt.compiler.api.DefaultCompilationProblem;
import com.google.code.sbt.compiler.api.DefaultSourcePosition;
import com.google.code.sbt.compiler.api.SourcePosition;
import com.google.code.sbt.compiler.sbt012.SBT012Analysis;
import com.google.code.sbt.compiler.sbt012.SBT012Logger;
import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.Setup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.component.annotations.Component;
import xsbti.CompileFailed;
import xsbti.Logger;
import xsbti.Maybe;
import xsbti.Position;
import xsbti.Problem;

@Component(role=com.google.code.sbt.compiler.api.Compiler.class, hint="sbt012", description="SBT 0.12.x compiler (uses Zinc 0.2.5)")
public class SBT012Compiler
extends AbstractCompiler {
    private static final String COMPILE_ORDER = "mixed";
    private static final Pattern JAVAC_ERROR = Pattern.compile("\\s*(.*[.]java):(\\d+):\\s*(.*)");
    private static final Pattern JAVAC_ERROR_POSITION = Pattern.compile("(\\s*)\\^\\s*");
    private static final Pattern JAVAC_ERROR_INFO = Pattern.compile("\\s+([a-z ]+):(.*)");

    public String getDefaultScalaVersion() {
        return "2.10.0";
    }

    public String getDefaultSbtVersion() {
        return "0.12.2";
    }

    public boolean supportsSourcePositionMappers() {
        return false;
    }

    public Analysis performCompile(CompilerConfiguration configuration) throws CompilerException {
        CompilerLogger logger = configuration.getLogger();
        SBT012Logger sbtLogger = new SBT012Logger(logger);
        Setup setup = Setup.create((File)configuration.getScalaCompilerFile(), (File)configuration.getScalaLibraryFile(), (List)configuration.getScalaExtraJarFiles(), (File)configuration.getXsbtiFile(), (File)configuration.getCompilerInterfaceSrcFile(), null);
        if (logger.isDebugEnabled()) {
            Setup.debug((Setup)setup, (Logger)sbtLogger);
        }
        Compiler compiler = Compiler.create((Setup)setup, (Logger)sbtLogger);
        Inputs inputs = Inputs.create((List)configuration.getClasspathFiles(), (List)configuration.getSourceFiles(), (File)configuration.getOutputDirectory(), (List)this.resolveScalacOptions(configuration), (List)this.resolveJavacOptions(configuration), (File)configuration.getAnalysisCacheFile(), (Map)configuration.getAnalysisCacheMap(), (String)COMPILE_ORDER, (boolean)logger.isDebugEnabled());
        if (configuration.getSourcePositionMapper() != null) {
            logger.warn("Source position mappers not supported");
        }
        if (logger.isDebugEnabled()) {
            Inputs.debug((Inputs)inputs, (Logger)sbtLogger);
        }
        try {
            return new SBT012Analysis(compiler.compile(inputs, (Logger)sbtLogger));
        }
        catch (CompileFailed e) {
            CompilationProblem[] problems = this.getScalacProblems(e.problems());
            if (problems.length == 0) {
                String[] consoleErrorLines = sbtLogger.getConsoleErrorLines();
                problems = this.getJavacProblems(consoleErrorLines);
            }
            throw new CompilerException("Scala compilation failed", (Throwable)e, problems);
        }
    }

    private CompilationProblem[] getScalacProblems(Problem[] problems) {
        CompilationProblem[] result = new CompilationProblem[problems.length];
        for (int i = 0; i < problems.length; ++i) {
            Problem problem = problems[i];
            Position position = problem.position();
            Maybe line = position.line();
            String lineContent = position.lineContent();
            Maybe offset = position.offset();
            Maybe pointer = position.pointer();
            Maybe sourceFile = position.sourceFile();
            DefaultSourcePosition sp = new DefaultSourcePosition(line.isDefined() ? (Integer)line.get() : -1, lineContent, offset.isDefined() ? (Integer)offset.get() : -1, pointer.isDefined() ? (Integer)pointer.get() : -1, sourceFile.isDefined() ? (File)sourceFile.get() : null);
            result[i] = new DefaultCompilationProblem(problem.category(), problem.message(), (SourcePosition)sp, problem.severity().name());
        }
        return result;
    }

    private CompilationProblem[] getJavacProblems(String[] consoleErrorLines) {
        ArrayList<DefaultCompilationProblem> problems = new ArrayList<DefaultCompilationProblem>();
        int i = 0;
        while (i < consoleErrorLines.length) {
            String line = consoleErrorLines[i];
            Matcher matcher = JAVAC_ERROR.matcher(line);
            if (matcher.find()) {
                File file = new File(matcher.group(1));
                int lineNo = Integer.parseInt(matcher.group(2));
                String message = matcher.group(3);
                if (message.startsWith("error: ")) {
                    message = message.substring("error: ".length());
                }
                String lineContent = null;
                int pointer = -1;
                if (++i < consoleErrorLines.length) {
                    lineContent = consoleErrorLines[i];
                    ++i;
                    while (i < consoleErrorLines.length) {
                        line = consoleErrorLines[i];
                        ++i;
                        matcher = JAVAC_ERROR_POSITION.matcher(line);
                        if (matcher.find()) break;
                        message = message + "\n  " + lineContent;
                        lineContent = line;
                    }
                    pointer = matcher.group(1).length();
                    while (i < consoleErrorLines.length && (matcher = JAVAC_ERROR_INFO.matcher(line = consoleErrorLines[i])).matches()) {
                        message = message + '\n' + line;
                        ++i;
                    }
                }
                DefaultSourcePosition position = new DefaultSourcePosition(lineNo, lineContent, -1, pointer, file);
                DefaultCompilationProblem problem = new DefaultCompilationProblem("", message, (SourcePosition)position, "Error");
                problems.add(problem);
                continue;
            }
            ++i;
        }
        return problems.toArray(new CompilationProblem[0]);
    }
}

