/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.sbt.compiler.sbt0137;

import com.google.code.sbt.compiler.api.AbstractCompiler;
import com.google.code.sbt.compiler.api.Analysis;
import com.google.code.sbt.compiler.api.CompilerConfiguration;
import com.google.code.sbt.compiler.api.CompilerException;
import com.google.code.sbt.compiler.sbt0137.SBT0137Analysis;
import com.google.code.sbt.compiler.sbt0137.SBT0137Logger;
import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.IncOptions;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.Setup;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import scala.Option;
import xsbti.CompileFailed;
import xsbti.Logger;

@Component(role=com.google.code.sbt.compiler.api.Compiler.class, hint="sbt0137", description="SBT 0.13.7 compiler (uses Zinc 0.3.7)")
public class SBT0137Compiler
extends AbstractCompiler {
    private static final String COMPILE_ORDER = "mixed";
    private static final boolean FORK_JAVA = false;

    public String getDefaultScalaVersion() {
        return "2.10.4";
    }

    public String getDefaultSbtVersion() {
        return "0.13.7";
    }

    public Analysis performCompile(CompilerConfiguration configuration) throws CompilerException {
        SBT0137Logger sbtLogger = new SBT0137Logger(configuration.getLogger());
        Setup setup = Setup.create((File)configuration.getScalaCompilerFile(), (File)configuration.getScalaLibraryFile(), (List)configuration.getScalaExtraJarFiles(), (File)configuration.getXsbtiFile(), (File)configuration.getCompilerInterfaceSrcFile(), null, (boolean)false);
        if (configuration.getLogger().isDebugEnabled()) {
            Setup.debug((Setup)setup, (Logger)sbtLogger);
        }
        Compiler compiler = Compiler.create((Setup)setup, (Logger)sbtLogger);
        Inputs inputs = Inputs.create((List)configuration.getClasspathFiles(), (List)configuration.getSourceFiles(), (File)configuration.getOutputDirectory(), (List)this.resolveScalacOptions(configuration), (List)this.resolveJavacOptions(configuration), (File)configuration.getAnalysisCacheFile(), (Map)configuration.getAnalysisCacheMap(), (String)COMPILE_ORDER, (IncOptions)this.getIncOptions(), (boolean)false);
        if (configuration.getLogger().isDebugEnabled()) {
            Inputs.debug((Inputs)inputs, (Logger)sbtLogger);
        }
        try {
            return new SBT0137Analysis(compiler.compile(inputs, (Logger)sbtLogger));
        }
        catch (CompileFailed e) {
            throw new CompilerException("Scala compilation failed", (Throwable)e);
        }
    }

    private IncOptions getIncOptions() {
        int transitiveStep = 3;
        double recompileAllFraction = 0.5;
        boolean relationsDebug = false;
        boolean apiDebug = false;
        int apiDiffContextSize = 5;
        Option apiDumpDirectory = Option.empty();
        boolean transactional = false;
        Option backup = Option.empty();
        boolean recompileOnMacroDef = true;
        boolean nameHashing = false;
        return new IncOptions(transitiveStep, recompileAllFraction, relationsDebug, apiDebug, apiDiffContextSize, apiDumpDirectory, transactional, backup, recompileOnMacroDef, nameHashing);
    }
}

