/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.test.svc;

import com.google.code.ssm.test.dao.AppUserDAO;
import com.google.code.ssm.test.entity.AppUser;
import com.google.code.ssm.test.entity.AppUserPK;
import com.google.code.ssm.test.svc.AppUserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppUserServiceImpl
implements AppUserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUserServiceImpl.class);
    @Autowired
    private AppUserDAO dao;

    @Override
    public void disableAppForUser(int userId, int applicationId) {
        AppUserPK pk = new AppUserPK(userId, applicationId);
        AppUser appUser = this.getApplicationUserFromDB(pk);
        if (appUser != null && appUser.isEnabled()) {
            appUser.setEnabled(false);
            this.getDao().update(appUser);
            HashSet<Integer> appsIdsSet = new HashSet<Integer>(this.getDao().getAppIdList(userId, true));
            if (appsIdsSet.remove(applicationId)) {
                this.getDao().updateListInCache(userId, true, new ArrayList<Integer>(appsIdsSet));
            }
            if ((appsIdsSet = new HashSet<Integer>(this.getDao().getAppIdList(userId, false))).add(applicationId)) {
                this.getDao().updateListInCache(userId, false, new ArrayList<Integer>(appsIdsSet));
            }
        } else {
            LOGGER.info("Appuser with PK: " + pk + " won't be uninstalled because it is null or already not marked as authorized: " + appUser);
        }
    }

    @Override
    public void enableAppForUser(int userId, int applicationId, boolean favourite) {
        AppUserPK pk = new AppUserPK(userId, applicationId);
        AppUser appUser = this.getApplicationUserFromDB(pk);
        if (appUser == null) {
            appUser = new AppUser(pk);
        }
        appUser.setEnabled(true);
        if (appUser.getVersion() != 0) {
            this.getDao().update(appUser);
        } else {
            this.getDao().create(appUser);
        }
        HashSet<Integer> appsIdsSet = new HashSet<Integer>(this.getDao().getAppIdList(userId, true));
        if (appsIdsSet.add(applicationId)) {
            this.getDao().updateListInCache(userId, true, new ArrayList<Integer>(appsIdsSet));
        }
        if ((appsIdsSet = new HashSet<Integer>(this.getDao().getAppIdList(userId, false))).remove(applicationId)) {
            this.getDao().updateListInCache(userId, false, new ArrayList<Integer>(appsIdsSet));
        }
    }

    @Override
    public AppUser get(int userId, int applicationId) {
        return this.getDao().getByPk(new AppUserPK(userId, applicationId));
    }

    @Override
    public List<AppUser> getInstalledList(int userId, List<Integer> applicationsIds) {
        Collections.sort(applicationsIds);
        List<AppUser> applicationUsers = this.getDao().getList(userId, applicationsIds);
        Iterator<AppUser> iter = applicationUsers.iterator();
        AppUser appUser = null;
        while (iter.hasNext()) {
            appUser = iter.next();
            if (appUser != null && appUser.isEnabled()) continue;
            iter.remove();
        }
        return applicationUsers;
    }

    @Override
    public List<AppUser> getList(int userId) {
        List<Integer> appsIds = this.getDao().getAppIdList(userId, true);
        appsIds.addAll(this.getDao().getAppIdList(userId, false));
        return this.getDao().getList(userId, this.getUniqueSortedList(appsIds));
    }

    @Override
    public List<AppUser> getList(int userId, boolean authorized) {
        List<Integer> appsIds = this.getUniqueSortedList(this.getDao().getAppIdList(userId, authorized));
        List<AppUser> appUsers = this.getDao().getList(userId, appsIds);
        this.removeWithDifferentAuth(appUsers, authorized);
        return appUsers;
    }

    @Override
    public List<Integer> getUserIdsList(int applicationId, List<Integer> userIds) {
        ArrayList<AppUser> applicationUsers = new ArrayList<AppUser>();
        ArrayList<Integer> notFoundUsersIds = new ArrayList<Integer>();
        List<AppUser> result = this.getDao().getUsersListFromCache(applicationId, userIds, notFoundUsersIds);
        if (result != null) {
            applicationUsers.addAll(result);
        }
        if (!notFoundUsersIds.isEmpty()) {
            Collections.sort(notFoundUsersIds);
            applicationUsers.addAll(this.getDao().getUsersList(applicationId, notFoundUsersIds));
        }
        ArrayList<Integer> idsOfAppUsers = new ArrayList<Integer>(applicationUsers.size());
        for (AppUser au : applicationUsers) {
            if (au == null || !au.isEnabled()) continue;
            idsOfAppUsers.add(au.getUserId());
        }
        return idsOfAppUsers;
    }

    @Override
    public boolean isEnabled(int userId, int applicationId) {
        AppUser au = this.get(userId, applicationId);
        return this.isAuthorized(au);
    }

    private AppUser getApplicationUserFromDB(AppUserPK pk) {
        return this.getDao().getByPKFromDB(pk);
    }

    private boolean isAuthorized(AppUser applicationUser) {
        return applicationUser != null && applicationUser.isEnabled();
    }

    private List<Integer> getUniqueSortedList(List<Integer> list) {
        ArrayList<Integer> uniqueList = new ArrayList<Integer>(new HashSet<Integer>(list));
        Collections.sort(uniqueList);
        return uniqueList;
    }

    private List<Integer> removeWithDifferentAuth(List<AppUser> appUsers, boolean authorized) {
        ArrayList<Integer> removedAppIds = new ArrayList<Integer>();
        Iterator<AppUser> iter = appUsers.iterator();
        AppUser appUser = null;
        while (iter.hasNext()) {
            appUser = iter.next();
            if (appUser.isEnabled() == authorized) continue;
            iter.remove();
            removedAppIds.add(appUser.getApplicationId());
        }
        return removedAppIds;
    }

    private AppUserDAO getDao() {
        return this.dao;
    }
}

