/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.test.dao;

import com.google.code.ssm.api.CacheName;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterDataUpdateContent;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import com.google.code.ssm.api.UpdateSingleCache;
import com.google.code.ssm.test.dao.MultiCacheDAO;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="multiCacheDao")
public class MultiCacheDAOImpl
implements MultiCacheDAO {
    private final Map<String, String> storedValues = new HashMap<String, String>();

    @Override
    @UpdateSingleCache(namespace="multi", expiration=30)
    public void storeToDefault(@ParameterValueKeyProvider String key, @ParameterDataUpdateContent String value) {
        this.storedValues.put(key, value);
    }

    @Override
    @ReadThroughSingleCache(namespace="multi", expiration=30)
    public String getFromDefault(@ParameterValueKeyProvider String key) {
        return this.storedValues.get(key);
    }

    @Override
    @InvalidateSingleCache(namespace="multi")
    public void removeFromDefault(@ParameterValueKeyProvider String key) {
        this.storedValues.remove(key);
    }

    @Override
    @CacheName(value="cache1")
    @UpdateSingleCache(namespace="multi", expiration=30)
    public void storeToDedicated(@ParameterValueKeyProvider String key, @ParameterDataUpdateContent String value) {
        this.storedValues.put(key, value);
    }

    @Override
    @CacheName(value="cache1Alias")
    @ReadThroughSingleCache(namespace="multi", expiration=30)
    public String getFromDedicated(@ParameterValueKeyProvider String key) {
        return this.storedValues.get(key);
    }

    @Override
    @CacheName(value="cache1Alias")
    @InvalidateSingleCache(namespace="multi")
    public void removeFromDedicated(@ParameterValueKeyProvider String key) {
        this.storedValues.remove(key);
    }
}

