/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.test.dao;

import com.google.code.ssm.api.InvalidateAssignCache;
import com.google.code.ssm.api.InvalidateMultiCache;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterDataUpdateContent;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughMultiCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import com.google.code.ssm.api.ReturnDataUpdateContent;
import com.google.code.ssm.api.ReturnValueKeyProvider;
import com.google.code.ssm.api.UpdateAssignCache;
import com.google.code.ssm.api.UpdateMultiCache;
import com.google.code.ssm.api.UpdateSingleCache;
import com.google.code.ssm.api.counter.DecrementCounterInCache;
import com.google.code.ssm.api.counter.IncrementCounterInCache;
import com.google.code.ssm.api.counter.ReadCounterFromCache;
import com.google.code.ssm.api.counter.UpdateCounterInCache;
import com.google.code.ssm.test.dao.TestDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.stereotype.Repository;

@Repository(value="testDao")
public class TestDAOImpl
implements TestDAO {
    @Override
    @ReadThroughSingleCache(namespace="Alpha", expiration=30)
    public String getDateString(@ParameterValueKeyProvider String key) {
        Date now = new Date();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return now.toString() + ":" + now.getTime();
    }

    @Override
    @UpdateSingleCache(namespace="Alpha", expiration=30)
    public void overrideDateString(int trash, @ParameterValueKeyProvider String key, @ParameterDataUpdateContent String overrideData) {
    }

    @Override
    @ReadThroughMultiCache(namespace="Bravo", expiration=300)
    public List<String> getTimestampValues(@ParameterValueKeyProvider List<Long> keys) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Long now = new Date().getTime();
        for (Long key : keys) {
            results.add(now.toString() + "-X-" + key.toString());
        }
        return results;
    }

    @Override
    @UpdateSingleCache(namespace="Bravo", expiration=300)
    @ReturnDataUpdateContent
    public String updateTimestampValue(@ParameterValueKeyProvider Long key) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Long now = new Date().getTime();
        return now.toString() + "-U-" + key.toString();
    }

    @Override
    @UpdateMultiCache(namespace="Bravo", expiration=300)
    @ReturnDataUpdateContent
    public List<String> updateTimestamValues(@ParameterValueKeyProvider List<Long> keys) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Long now = new Date().getTime();
        ArrayList<String> results = new ArrayList<String>();
        for (Long key : keys) {
            results.add(now.toString() + "-M-" + key.toString());
        }
        return results;
    }

    @Override
    @UpdateMultiCache(namespace="Bravo", expiration=300)
    public void overrideTimestampValues(int trash, @ParameterValueKeyProvider List<Long> keys, String nuthin, @ParameterDataUpdateContent List<String> overrideData) {
    }

    @Override
    @ReadThroughSingleCache(namespace="Charlie", expiration=1000)
    public String getRandomString(@ParameterValueKeyProvider Long key) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return RandomStringUtils.randomAlphanumeric((int)(25 + RandomUtils.nextInt((int)30)));
    }

    @Override
    @InvalidateSingleCache(namespace="Charlie")
    public void updateRandomString(@ParameterValueKeyProvider Long key) {
    }

    @Override
    @InvalidateSingleCache(namespace="Charlie")
    @ReturnValueKeyProvider
    public Long updateRandomStringAgain(Long key) {
        return key;
    }

    @Override
    @ReadThroughMultiCache(namespace="Delta", expiration=1000)
    public List<String> getRandomStrings(@ParameterValueKeyProvider List<Long> keys) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String series = RandomStringUtils.randomAlphabetic((int)6);
        ArrayList<String> results = new ArrayList<String>(keys.size());
        for (Long key : keys) {
            results.add(series + "-" + key.toString() + "-" + RandomStringUtils.randomAlphanumeric((int)(25 + RandomUtils.nextInt((int)30))));
        }
        return results;
    }

    @Override
    @InvalidateMultiCache(namespace="Delta")
    public void updateRandomStrings(@ParameterValueKeyProvider List<Long> keys) {
    }

    @Override
    @InvalidateMultiCache(namespace="Delta")
    @ReturnValueKeyProvider
    public List<Long> updateRandomStringsAgain(List<Long> keys) {
        return keys;
    }

    @Override
    @ReadThroughAssignCache(assignedKey="SomePhatKey", namespace="Echo", expiration=3000)
    public List<String> getAssignStrings() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<String> results = new ArrayList<String>();
        long extra = System.currentTimeMillis() % 20L;
        String base = System.currentTimeMillis() + "";
        int ix = 0;
        while ((long)ix < 20L + extra) {
            results.add(ix + "-" + base);
            ++ix;
        }
        return results;
    }

    @Override
    @InvalidateAssignCache(assignedKey="SomePhatKey", namespace="Echo")
    public void invalidateAssignStrings() {
    }

    @Override
    @UpdateAssignCache(assignedKey="SomePhatKey", namespace="Echo", expiration=3000)
    public void updateAssignStrings(int bubpkus, @ParameterDataUpdateContent List<String> newData) {
    }

    @Override
    @DecrementCounterInCache(namespace="Omega")
    public void decrement(@ParameterValueKeyProvider String key) {
    }

    @Override
    @IncrementCounterInCache(namespace="Omega")
    public void increment(@ParameterValueKeyProvider String key) {
    }

    @Override
    @ReadCounterFromCache(namespace="Omega")
    public long getCounter(@ParameterValueKeyProvider String key) {
        return 100L;
    }

    @Override
    @UpdateCounterInCache(namespace="Omega", expiration=100)
    public void update(@ParameterValueKeyProvider String key, @ParameterDataUpdateContent Long value) {
    }

    @Override
    @InvalidateSingleCache(namespace="Omega")
    public void invalidate(@ParameterValueKeyProvider String key) {
    }

    @Override
    @UpdateSingleCache(namespace="Echo", expiration=3000)
    public void updateValue(@ParameterValueKeyProvider String key, @ParameterDataUpdateContent String value) {
    }

    @Override
    @ReadThroughSingleCache(namespace="Echo", expiration=3000)
    public String getValue(@ParameterValueKeyProvider String key) {
        return "some value";
    }
}

