/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.test.entity;

import com.google.code.ssm.api.CacheKeyMethod;
import com.google.code.ssm.test.entity.AppUserPK;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AppUser
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int CLASS_VERSION = 1;
    private int userId;
    private int applicationId;
    private boolean enabled;
    private int version;

    public AppUser() {
    }

    public AppUser(int userId, int applicationId) {
        this.userId = userId;
        this.applicationId = applicationId;
    }

    public AppUser(AppUserPK pk) {
        this(pk.getUserId(), pk.getApplicationId());
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(int applicationId) {
        this.applicationId = applicationId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.userId = in.readInt();
        this.applicationId = in.readInt();
        this.enabled = in.readBoolean();
        this.version = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.userId);
        out.writeInt(this.applicationId);
        out.writeBoolean(this.enabled);
        out.writeInt(this.version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.applicationId;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.userId;
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppUser other = (AppUser)obj;
        if (this.applicationId != other.applicationId) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.userId != other.userId) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return String.format("AppUser [userId=%d, applicationId=%d, enabled=%b, verion=%d]", this.userId, this.applicationId, this.enabled, this.version);
    }

    @CacheKeyMethod
    public String cacheKey() {
        return this.userId + "/" + this.applicationId;
    }

    public AppUserPK getPK() {
        return new AppUserPK(this.userId, this.applicationId);
    }
}

