/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AutoValue_AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.HiltCompilerOptions;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Components;
import dagger.hilt.processor.internal.KotlinMetadataUtils;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class AndroidEntryPointMetadata {
    private static final ImmutableSet<ClassName> HILT_ANNOTATION_NAMES = ImmutableSet.of((Object)AndroidClassNames.HILT_ANDROID_APP, (Object)AndroidClassNames.ANDROID_ENTRY_POINT);

    public abstract TypeElement element();

    public abstract TypeElement baseElement();

    public abstract ClassName generatedClassName();

    public abstract boolean requiresBytecodeInjection();

    public abstract AndroidType androidType();

    public abstract Optional<AndroidEntryPointMetadata> baseMetadata();

    public abstract ImmutableSet<ClassName> installInComponents();

    public abstract TypeName componentManager();

    public abstract Optional<CodeBlock> componentManagerInitArgs();

    public AndroidEntryPointMetadata rootMetadata() {
        return this.baseMetadata().map(AndroidEntryPointMetadata::rootMetadata).orElse(this);
    }

    boolean isRootMetadata() {
        return this.equals(this.rootMetadata());
    }

    public boolean allowsOptionalInjection() {
        return Processors.hasAnnotation((Element)this.element(), AndroidClassNames.OPTIONAL_INJECT);
    }

    public boolean baseAllowsOptionalInjection() {
        return this.baseMetadata().isPresent() && this.baseMetadata().get().allowsOptionalInjection();
    }

    public boolean overridesAndroidEntryPointClass() {
        return this.baseMetadata().isPresent();
    }

    public ClassName elementClassName() {
        return ClassName.get((TypeElement)this.element());
    }

    public TypeName baseClassName() {
        return TypeName.get((TypeMirror)this.baseElement().asType());
    }

    public ClassName injectorClassName() {
        return Processors.append(Processors.getEnclosedClassName(this.elementClassName()), "_GeneratedInjector");
    }

    public String injectMethodName() {
        return "inject" + Processors.getEnclosedName(this.elementClassName());
    }

    public final AnnotationSpec injectorInstallInAnnotation() {
        return Components.getInstallInAnnotationSpec(this.installInComponents());
    }

    public ParameterSpec componentManagerParam() {
        return ParameterSpec.builder((TypeName)this.componentManager(), (String)"componentManager", (Modifier[])new Modifier[0]).build();
    }

    public Modifier[] generatedClassModifiers() {
        Modifier[] modifierArray;
        if (AndroidEntryPointMetadata.isKotlinClass(this.element()) && this.element().getModifiers().contains((Object)Modifier.PUBLIC)) {
            Modifier[] modifierArray2 = new Modifier[2];
            modifierArray2[0] = Modifier.ABSTRACT;
            modifierArray = modifierArray2;
            modifierArray2[1] = Modifier.PUBLIC;
        } else {
            Modifier[] modifierArray3 = new Modifier[1];
            modifierArray = modifierArray3;
            modifierArray3[0] = Modifier.ABSTRACT;
        }
        return modifierArray;
    }

    private static ClassName generatedClassName(TypeElement element) {
        String prefix = "Hilt_";
        return Processors.prepend(Processors.getEnclosedClassName(ClassName.get((TypeElement)element)), prefix);
    }

    private static ImmutableSet<? extends AnnotationMirror> hiltAnnotations(Element element) {
        return (ImmutableSet)element.getAnnotationMirrors().stream().filter(mirror -> HILT_ANNOTATION_NAMES.contains((Object)ClassName.get((TypeMirror)mirror.getAnnotationType()))).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAndroidEntryPointMetadata(Element element) {
        return !AndroidEntryPointMetadata.hiltAnnotations(element).isEmpty();
    }

    public static AndroidEntryPointMetadata of(ProcessingEnvironment env, Element element) {
        LinkedHashSet<Element> inheritanceTrace = new LinkedHashSet<Element>();
        inheritanceTrace.add(element);
        return AndroidEntryPointMetadata.of(env, element, inheritanceTrace);
    }

    public static AndroidEntryPointMetadata manuallyConstruct(TypeElement element, TypeElement baseElement, ClassName generatedClassName, boolean requiresBytecodeInjection, AndroidType androidType, Optional<AndroidEntryPointMetadata> baseMetadata, ImmutableSet<ClassName> installInComponents, TypeName componentManager, Optional<CodeBlock> componentManagerInitArgs) {
        return new AutoValue_AndroidEntryPointMetadata(element, baseElement, generatedClassName, requiresBytecodeInjection, androidType, baseMetadata, installInComponents, componentManager, componentManagerInitArgs);
    }

    private static AndroidEntryPointMetadata of(ProcessingEnvironment env, Element element, LinkedHashSet<Element> inheritanceTrace) {
        ClassName generatedClassName;
        TypeElement baseElement;
        boolean requiresBytecodeInjection;
        ImmutableSet<? extends AnnotationMirror> hiltAnnotations = AndroidEntryPointMetadata.hiltAnnotations(element);
        ProcessorErrors.checkState(hiltAnnotations.size() == 1, element, "Expected exactly 1 of %s. Found: %s", HILT_ANNOTATION_NAMES, hiltAnnotations);
        ClassName annotationClassName = ClassName.get((TypeElement)MoreTypes.asTypeElement(((AnnotationMirror)Iterables.getOnlyElement(hiltAnnotations)).getAnnotationType()));
        ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS, element, "Only classes can be annotated with @%s", annotationClassName.simpleName());
        TypeElement androidEntryPointElement = MoreElements.asType(element);
        ProcessorErrors.checkState(androidEntryPointElement.getTypeParameters().isEmpty(), element, "@%s-annotated classes cannot have type parameters.", annotationClassName.simpleName());
        TypeElement androidEntryPointClassValue = Processors.getAnnotationClassValue(env.getElementUtils(), Processors.getAnnotationMirror((Element)androidEntryPointElement, annotationClassName), "value");
        boolean bl = requiresBytecodeInjection = HiltCompilerOptions.BooleanOption.DISABLE_ANDROID_SUPERCLASS_VALIDATION.get(env) && MoreTypes.isTypeOf(Void.class, androidEntryPointClassValue.asType());
        if (requiresBytecodeInjection) {
            baseElement = MoreElements.asType(env.getTypeUtils().asElement(androidEntryPointElement.getSuperclass()));
            KotlinMetadataUtil metadataUtil = KotlinMetadataUtils.getMetadataUtil();
            ProcessorErrors.checkState(!metadataUtil.hasMetadata((Element)androidEntryPointElement) || !metadataUtil.containsConstructorWithDefaultParam(baseElement), baseElement, "The base class, '%s', of the @AndroidEntryPoint, '%s', contains a constructor with default parameters. This is currently not supported by the Gradle plugin. Either specify the base class as described at https://dagger.dev/hilt/gradle-setup#why-use-the-plugin or remove the default value declaration.", baseElement.getQualifiedName(), androidEntryPointElement.getQualifiedName());
            generatedClassName = AndroidEntryPointMetadata.generatedClassName(androidEntryPointElement);
        } else {
            baseElement = androidEntryPointClassValue;
            ProcessorErrors.checkState(!MoreTypes.isTypeOf(Void.class, baseElement.asType()), androidEntryPointElement, "Expected @%s to have a value. Did you forget to apply the Gradle Plugin? (dagger.hilt.android.plugin)\nSee https://dagger.dev/hilt/gradle-setup.html", annotationClassName.simpleName());
            String extendsName = env.getTypeUtils().asElement(androidEntryPointElement.getSuperclass()).getSimpleName().toString();
            generatedClassName = AndroidEntryPointMetadata.generatedClassName(androidEntryPointElement);
            ProcessorErrors.checkState(extendsName.contentEquals(generatedClassName.simpleName()), androidEntryPointElement, "@%s class expected to extend %s. Found: %s", annotationClassName.simpleName(), generatedClassName.simpleName(), extendsName);
        }
        Optional<AndroidEntryPointMetadata> baseMetadata = AndroidEntryPointMetadata.baseMetadata(env, androidEntryPointElement, baseElement, inheritanceTrace);
        if (baseMetadata.isPresent()) {
            return AndroidEntryPointMetadata.manuallyConstruct(androidEntryPointElement, baseElement, generatedClassName, requiresBytecodeInjection, baseMetadata.get().androidType(), baseMetadata, baseMetadata.get().installInComponents(), baseMetadata.get().componentManager(), baseMetadata.get().componentManagerInitArgs());
        }
        Type type = Type.of(androidEntryPointElement, baseElement);
        return AndroidEntryPointMetadata.manuallyConstruct(androidEntryPointElement, baseElement, generatedClassName, requiresBytecodeInjection, type.androidType, Optional.empty(), (ImmutableSet<ClassName>)ImmutableSet.of((Object)type.component), (TypeName)type.manager, Optional.ofNullable(type.componentManagerInitArgs));
    }

    private static Optional<AndroidEntryPointMetadata> baseMetadata(ProcessingEnvironment env, TypeElement element, TypeElement baseElement, LinkedHashSet<Element> inheritanceTrace) {
        ProcessorErrors.checkState(inheritanceTrace.add(baseElement), element, (Object)AndroidEntryPointMetadata.cyclicInheritanceErrorMessage(inheritanceTrace, baseElement));
        if (AndroidEntryPointMetadata.hasAndroidEntryPointMetadata(baseElement)) {
            AndroidEntryPointMetadata baseMetadata = AndroidEntryPointMetadata.of(env, baseElement, inheritanceTrace);
            AndroidEntryPointMetadata.checkConsistentAnnotations(element, baseMetadata);
            return Optional.of(baseMetadata);
        }
        TypeMirror superClass = baseElement.getSuperclass();
        if (superClass.getKind() != TypeKind.NONE && superClass.getKind() != TypeKind.ERROR) {
            Preconditions.checkState((superClass.getKind() == TypeKind.DECLARED ? 1 : 0) != 0);
            return AndroidEntryPointMetadata.baseMetadata(env, element, MoreTypes.asTypeElement(superClass), inheritanceTrace);
        }
        return Optional.empty();
    }

    private static String cyclicInheritanceErrorMessage(LinkedHashSet<Element> inheritanceTrace, TypeElement cycleEntryPoint) {
        return String.format("Cyclic inheritance detected. Make sure the base class of @AndroidEntryPoint is not the annotated class itself or subclass of the annotated class.\nThe cyclic inheritance structure: %s --> %s\n", inheritanceTrace.stream().map(Element::asType).map(TypeMirror::toString).collect(Collectors.joining(" --> ")), cycleEntryPoint.asType());
    }

    private static boolean isKotlinClass(TypeElement typeElement) {
        return typeElement.getAnnotationMirrors().stream().map(mirror -> mirror.getAnnotationType()).anyMatch(type -> ClassName.get((TypeMirror)type).equals((Object)ClassNames.KOTLIN_METADATA));
    }

    private static void checkConsistentAnnotations(TypeElement element, AndroidEntryPointMetadata baseMetadata) {
        TypeElement baseElement = baseMetadata.element();
        AndroidEntryPointMetadata.checkAnnotationsMatch(element, baseElement, AndroidClassNames.WITH_FRAGMENT_BINDINGS);
        ProcessorErrors.checkState(baseMetadata.allowsOptionalInjection() || !Processors.hasAnnotation((Element)element, AndroidClassNames.OPTIONAL_INJECT), element, "@OptionalInject Hilt class cannot extend from a non-optional @AndroidEntryPoint base: %s", element);
    }

    private static void checkAnnotationsMatch(TypeElement element, TypeElement baseElement, ClassName annotationName) {
        boolean isBaseAnnotated;
        boolean isAnnotated = Processors.hasAnnotation((Element)element, annotationName);
        ProcessorErrors.checkState(isAnnotated == (isBaseAnnotated = Processors.hasAnnotation((Element)baseElement, annotationName)), element, isBaseAnnotated ? "Classes that extend an @%1$s base class must also be annotated @%1$s" : "Classes that extend a @AndroidEntryPoint base class must not use @%1$s when the base class does not use @%1$s", annotationName.simpleName());
    }

    private static final class Type {
        private static final Type APPLICATION = new Type(AndroidClassNames.SINGLETON_COMPONENT, AndroidType.APPLICATION, AndroidClassNames.APPLICATION_COMPONENT_MANAGER, null);
        private static final Type SERVICE = new Type(AndroidClassNames.SERVICE_COMPONENT, AndroidType.SERVICE, AndroidClassNames.SERVICE_COMPONENT_MANAGER, CodeBlock.of((String)"this", (Object[])new Object[0]));
        private static final Type BROADCAST_RECEIVER = new Type(AndroidClassNames.SINGLETON_COMPONENT, AndroidType.BROADCAST_RECEIVER, AndroidClassNames.BROADCAST_RECEIVER_COMPONENT_MANAGER, null);
        private static final Type ACTIVITY = new Type(AndroidClassNames.ACTIVITY_COMPONENT, AndroidType.ACTIVITY, AndroidClassNames.ACTIVITY_COMPONENT_MANAGER, CodeBlock.of((String)"this", (Object[])new Object[0]));
        private static final Type FRAGMENT = new Type(AndroidClassNames.FRAGMENT_COMPONENT, AndroidType.FRAGMENT, AndroidClassNames.FRAGMENT_COMPONENT_MANAGER, CodeBlock.of((String)"this", (Object[])new Object[0]));
        private static final Type VIEW = new Type(AndroidClassNames.VIEW_WITH_FRAGMENT_COMPONENT, AndroidType.VIEW, AndroidClassNames.VIEW_COMPONENT_MANAGER, CodeBlock.of((String)"this, true /* hasFragmentBindings */", (Object[])new Object[0]));
        private static final Type VIEW_NO_FRAGMENT = new Type(AndroidClassNames.VIEW_COMPONENT, AndroidType.VIEW, AndroidClassNames.VIEW_COMPONENT_MANAGER, CodeBlock.of((String)"this, false /* hasFragmentBindings */", (Object[])new Object[0]));
        final ClassName component;
        final AndroidType androidType;
        final ClassName manager;
        final CodeBlock componentManagerInitArgs;

        Type(ClassName component, AndroidType androidType, ClassName manager, CodeBlock componentManagerInitArgs) {
            this.component = component;
            this.androidType = androidType;
            this.manager = manager;
            this.componentManagerInitArgs = componentManagerInitArgs;
        }

        AndroidType androidType() {
            return this.androidType;
        }

        private static Type of(TypeElement element, TypeElement baseElement) {
            if (Processors.hasAnnotation((Element)element, AndroidClassNames.HILT_ANDROID_APP)) {
                return Type.forHiltAndroidApp(element, baseElement);
            }
            return Type.forAndroidEntryPoint(element, baseElement);
        }

        private static Type forHiltAndroidApp(TypeElement element, TypeElement baseElement) {
            ProcessorErrors.checkState(Processors.isAssignableFrom(baseElement, AndroidClassNames.APPLICATION), element, "@HiltAndroidApp base class must extend Application. Found: %s", baseElement);
            return APPLICATION;
        }

        private static Type forAndroidEntryPoint(TypeElement element, TypeElement baseElement) {
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.ACTIVITY)) {
                ProcessorErrors.checkState(Processors.isAssignableFrom(baseElement, AndroidClassNames.COMPONENT_ACTIVITY), element, (Object)"Activities annotated with @AndroidEntryPoint must be a subclass of androidx.activity.ComponentActivity. (e.g. FragmentActivity, AppCompatActivity, etc.)");
                return ACTIVITY;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.SERVICE)) {
                return SERVICE;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.BROADCAST_RECEIVER)) {
                return BROADCAST_RECEIVER;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.FRAGMENT)) {
                return FRAGMENT;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.VIEW)) {
                boolean withFragmentBindings = Processors.hasAnnotation((Element)element, AndroidClassNames.WITH_FRAGMENT_BINDINGS);
                return withFragmentBindings ? VIEW : VIEW_NO_FRAGMENT;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.APPLICATION)) {
                throw new BadInputException("@AndroidEntryPoint cannot be used on an Application. Use @HiltAndroidApp instead.", element);
            }
            throw new BadInputException("@AndroidEntryPoint base class must extend ComponentActivity, (support) Fragment, View, Service, or BroadcastReceiver.", element);
        }
    }

    public static enum AndroidType {
        APPLICATION,
        ACTIVITY,
        BROADCAST_RECEIVER,
        FRAGMENT,
        SERVICE,
        VIEW;

    }
}

