/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;

public final class HiltCompilerOptions {
    public static Set<String> getProcessorOptions() {
        return Arrays.stream(BooleanOption.values()).map(BooleanOption::getQualifiedName).collect(Collectors.toSet());
    }

    private HiltCompilerOptions() {
    }

    public static enum BooleanOption {
        DISABLE_ANDROID_SUPERCLASS_VALIDATION("android.internal.disableAndroidSuperclassValidation", false),
        DISABLE_MODULES_HAVE_INSTALL_IN_CHECK("disableModulesHaveInstallInCheck", false);

        private final String name;
        private final boolean defaultValue;

        private BooleanOption(String name, boolean defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public boolean get(ProcessingEnvironment env) {
            String value = env.getOptions().get(this.getQualifiedName());
            if (value == null) {
                return this.defaultValue;
            }
            return Boolean.parseBoolean(value);
        }

        public String getQualifiedName() {
            return "dagger.hilt." + this.name;
        }
    }
}

