/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.DefineComponentBuilderMetadatas;
import dagger.hilt.processor.internal.definecomponent.DefineComponentMetadatas;
import dagger.hilt.processor.internal.definecomponent.DefineComponents;
import java.io.IOException;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public final class DefineComponentProcessor
extends BaseProcessor {
    private final DefineComponentMetadatas componentMetadatas = DefineComponentMetadatas.create();
    private final DefineComponentBuilderMetadatas componentBuilderMetadatas = DefineComponentBuilderMetadatas.create(this.componentMetadatas);

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.DEFINE_COMPONENT.toString(), (Object)ClassNames.DEFINE_COMPONENT_BUILDER.toString());
    }

    @Override
    protected void processEach(TypeElement annotation, Element element) throws Exception {
        if (ClassName.get((TypeElement)annotation).equals((Object)ClassNames.DEFINE_COMPONENT)) {
            DefineComponentMetadatas.DefineComponentMetadata metadata = this.componentMetadatas.get(element);
            this.generateFile("component", metadata.component());
        } else if (ClassName.get((TypeElement)annotation).equals((Object)ClassNames.DEFINE_COMPONENT_BUILDER)) {
            DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata metadata = this.componentBuilderMetadatas.get(element);
            this.generateFile("builder", metadata.builder());
        } else {
            throw new AssertionError((Object)("Unhandled annotation type: " + annotation));
        }
    }

    private void generateFile(String member, TypeElement typeElement) throws IOException {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)Processors.getFullEnclosedName(typeElement)).addOriginatingElement((Element)typeElement).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.DEFINE_COMPONENT_CLASSES).addMember(member, "$S", new Object[]{typeElement.getQualifiedName()}).build());
        Processors.addGeneratedAnnotation(builder, this.processingEnv, this.getClass());
        JavaFile.builder((String)DefineComponents.AGGREGATING_PACKAGE, (TypeSpec)builder.build()).build().writeTo(this.processingEnv.getFiler());
    }
}

