/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonInclude;
import endpoints.repackaged.com.fasterxml.jackson.databind.Module;
import endpoints.repackaged.com.fasterxml.jackson.databind.ObjectMapper;
import endpoints.repackaged.com.fasterxml.jackson.databind.ObjectReader;
import endpoints.repackaged.com.fasterxml.jackson.databind.ObjectWriter;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializationFeature;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.collect.ImmutableSet;
import endpoints.repackaged.com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class ConfiguredObjectMapper {
    @VisibleForTesting
    final ObjectMapper delegate;

    private ConfiguredObjectMapper(ObjectMapper delegate) {
        this.delegate = delegate;
    }

    public ObjectReader reader() {
        return this.delegate.reader();
    }

    public ObjectWriter writer() {
        return this.delegate.writer();
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    static class CacheKey {
        private final ApiSerializationConfig apiSerializationConfig;
        private final ImmutableSet<Module> modulesSet;

        private CacheKey(@Nullable ApiSerializationConfig config, ImmutableSet<Module> modules) {
            this.apiSerializationConfig = config;
            this.modulesSet = modules;
        }

        public int hashCode() {
            return Objects.hash(this.apiSerializationConfig, this.modulesSet);
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CacheKey) {
                CacheKey that = (CacheKey)object;
                return Objects.equals(this.apiSerializationConfig, that.apiSerializationConfig) && this.modulesSet.equals(that.modulesSet);
            }
            return false;
        }
    }

    public static class Builder {
        private static final Logger logger = Logger.getLogger(Builder.class.getName());
        private int maxCacheSize;
        private ApiSerializationConfig config;
        private ImmutableSet.Builder<Module> modules = ImmutableSet.builder();
        private static final Map<CacheKey, ConfiguredObjectMapper> globalCache = Maps.newConcurrentMap();
        private final Map<CacheKey, ConfiguredObjectMapper> cache;

        private Builder() {
            this(globalCache, 1000);
        }

        @VisibleForTesting
        Builder(Map<CacheKey, ConfiguredObjectMapper> mutableCache, int maxCacheSize) {
            Preconditions.checkArgument(maxCacheSize > 0, "cache should be positive");
            this.cache = Preconditions.checkNotNull(mutableCache, "cache should not be null");
            this.maxCacheSize = maxCacheSize;
        }

        public Builder apiSerializationConfig(@Nullable ApiSerializationConfig config) {
            this.config = config == null ? null : new ApiSerializationConfig(config);
            return this;
        }

        public Builder addRegisteredModules(Iterable<? extends Module> modules) {
            this.modules.addAll(modules);
            return this;
        }

        public ConfiguredObjectMapper build() {
            CacheKey key = new CacheKey(this.config, (ImmutableSet)this.modules.build());
            ConfiguredObjectMapper instance = this.cache.get(key);
            if (instance == null) {
                ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper(key.apiSerializationConfig);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                mapper.disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
                for (Module module : key.modulesSet) {
                    mapper.registerModule(module);
                }
                instance = new ConfiguredObjectMapper(mapper);
                if (this.maxCacheSize <= this.cache.size()) {
                    this.cache.clear();
                }
                this.cache.put(key, instance);
                logger.log(Level.FINE, "Cache miss, created ObjectMapper");
            } else {
                logger.log(Level.FINE, "Cache hit, reusing ObjectMapper");
            }
            return instance;
        }
    }
}

