/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public final class IoUtil {
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String GZIP_ENCODING = "gzip";
    @VisibleForTesting
    static final int BUFFER_SIZE = 1024;

    private IoUtil() {
    }

    public static String readResourceFile(Class<?> c, String fileName) throws IOException {
        URL url = c.getResource(fileName);
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = in.readLine();
        while (line != null) {
            sb.append(line);
            line = in.readLine();
        }
        return sb.toString();
    }

    public static void copy(InputStream in, File dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        int len = in.read(buf);
        while (len > 0) {
            ((OutputStream)out).write(buf, 0, len);
            len = in.read(buf);
        }
        in.close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[(int)file.length()];
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            randomAccessFile.readFully(buffer);
            String string = new String(buffer, "UTF-8");
            return string;
        }
    }

    public static List<String> readFiles(File directory, FileFilter filter) throws FileNotFoundException, IOException {
        ArrayList<String> contents = new ArrayList<String>();
        for (File file : directory.listFiles(filter)) {
            contents.add(IoUtil.readFile(file));
        }
        return contents;
    }

    public static String readStream(InputStream is) throws IOException {
        return IoUtil.readStream(is, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static String readStream(InputStream is, int bufferSize) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[bufferSize];
            int n = is.read(buffer);
            while (n > 0) {
                os.write(buffer, 0, n);
                n = is.read(buffer);
            }
            String string = os.toString("UTF-8");
            return string;
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static InputStream getRequestInputStream(HttpServletRequest request) throws IOException {
        ServletInputStream bodyStream = request.getInputStream();
        if (bodyStream != null && GZIP_ENCODING.equals(request.getHeader(HEADER_CONTENT_ENCODING))) {
            PushbackInputStream pushbackStream = new PushbackInputStream((InputStream)bodyStream, 2);
            byte[] header = new byte[2];
            int len = pushbackStream.read(header);
            if (len > 0) {
                pushbackStream.unread(header, 0, len);
            }
            return IoUtil.isGzipHeader(header) ? new GZIPInputStream(pushbackStream) : pushbackStream;
        }
        return bodyStream;
    }

    public static String readRequestBody(HttpServletRequest request) throws IOException {
        InputStream inputStream = IoUtil.getRequestInputStream(request);
        return inputStream != null ? IoUtil.readStream(inputStream) : null;
    }

    private static boolean isGzipHeader(byte[] header) {
        return header.length >= 2 && (header[0] | (header[1] & 0xFF) << 8) == 35615;
    }
}

