/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.AutoValue_ServletInitializationParameters;
import endpoints.repackaged.com.google.common.base.Function;
import endpoints.repackaged.com.google.common.base.Joiner;
import endpoints.repackaged.com.google.common.base.Splitter;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.collect.ImmutableSet;
import endpoints.repackaged.com.google.common.collect.Iterables;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public abstract class ServletInitializationParameters {
    private static final String SERVICES = "services";
    private static final String RESTRICTED = "restricted";
    private static final String CLIENT_ID_WHITELIST_ENABLED = "clientIdWhitelistEnabled";
    private static final String ILLEGAL_ARGUMENT_BACKEND_ERROR = "illegalArgumentIsBackendError";
    private static final String EXCEPTION_COMPATIBILITY = "enableExceptionCompatibility";
    private static final String PRETTY_PRINT = "prettyPrint";
    private static final Splitter CSV_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();
    private static final Joiner CSV_JOINER = Joiner.on(',').skipNulls();
    private static final Function<Class<?>, String> CLASS_TO_NAME = new Function<Class<?>, String>(){

        @Override
        public String apply(Class<?> clazz) {
            return clazz.getName();
        }
    };

    public abstract ImmutableSet<Class<?>> getServiceClasses();

    @Deprecated
    public abstract boolean isServletRestricted();

    public abstract boolean isClientIdWhitelistEnabled();

    public abstract boolean isIllegalArgumentBackendError();

    public abstract boolean isExceptionCompatibilityEnabled();

    public abstract boolean isPrettyPrintEnabled();

    public static Builder builder() {
        return new AutoValue_ServletInitializationParameters.Builder().setServletRestricted(true).setClientIdWhitelistEnabled(true).setIllegalArgumentBackendError(false).setExceptionCompatibilityEnabled(true).setPrettyPrintEnabled(true);
    }

    public static ServletInitializationParameters fromServletConfig(ServletConfig config, ClassLoader classLoader) throws ServletException {
        Builder builder = ServletInitializationParameters.builder();
        if (config != null) {
            String prettyPrint;
            String exceptionCompatibility;
            String illegalArgumentBackendError;
            String clientIdWhitelist;
            String servletRestricted;
            String serviceClassNames = config.getInitParameter(SERVICES);
            if (serviceClassNames != null) {
                for (String serviceClassName : CSV_SPLITTER.split(serviceClassNames)) {
                    builder.addServiceClass(ServletInitializationParameters.getClassForName(serviceClassName, classLoader));
                }
            }
            if ((servletRestricted = config.getInitParameter(RESTRICTED)) != null) {
                builder.setServletRestricted(ServletInitializationParameters.parseBoolean(servletRestricted, RESTRICTED));
            }
            if ((clientIdWhitelist = config.getInitParameter(CLIENT_ID_WHITELIST_ENABLED)) != null) {
                builder.setClientIdWhitelistEnabled(ServletInitializationParameters.parseBoolean(clientIdWhitelist, CLIENT_ID_WHITELIST_ENABLED));
            }
            if ((illegalArgumentBackendError = config.getInitParameter(ILLEGAL_ARGUMENT_BACKEND_ERROR)) != null) {
                builder.setIllegalArgumentBackendError(ServletInitializationParameters.parseBoolean(illegalArgumentBackendError, ILLEGAL_ARGUMENT_BACKEND_ERROR));
            }
            if ((exceptionCompatibility = config.getInitParameter(EXCEPTION_COMPATIBILITY)) != null) {
                builder.setExceptionCompatibilityEnabled(ServletInitializationParameters.parseBoolean(exceptionCompatibility, EXCEPTION_COMPATIBILITY));
            }
            if ((prettyPrint = config.getInitParameter(PRETTY_PRINT)) != null) {
                builder.setPrettyPrintEnabled(ServletInitializationParameters.parseBoolean(prettyPrint, PRETTY_PRINT));
            }
        }
        return builder.build();
    }

    private static boolean parseBoolean(String booleanString, String descriptionForErrors) {
        if ("true".equalsIgnoreCase(booleanString)) {
            return true;
        }
        if ("false".equalsIgnoreCase(booleanString)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Expected 'true' or 'false' for '%s' servlet initialization parameter but got '%s'", descriptionForErrors, booleanString));
    }

    private static Class<?> getClassForName(String className, ClassLoader classLoader) throws ServletException {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(String.format("Cannot find service class: %s", className), (Throwable)e);
        }
    }

    public ImmutableMap<String, String> asMap() {
        return ImmutableMap.builder().put(SERVICES, CSV_JOINER.join(Iterables.transform(this.getServiceClasses(), CLASS_TO_NAME))).put(RESTRICTED, Boolean.toString(this.isServletRestricted())).put(CLIENT_ID_WHITELIST_ENABLED, Boolean.toString(this.isClientIdWhitelistEnabled())).put(ILLEGAL_ARGUMENT_BACKEND_ERROR, Boolean.toString(this.isIllegalArgumentBackendError())).put(EXCEPTION_COMPATIBILITY, Boolean.toString(this.isExceptionCompatibilityEnabled())).put(PRETTY_PRINT, Boolean.toString(this.isPrettyPrintEnabled())).build();
    }

    public static abstract class Builder {
        private final ImmutableSet.Builder<Class<?>> serviceClasses = ImmutableSet.builder();

        public Builder addServiceClass(Class<?> serviceClass) {
            this.serviceClasses.add((Object)serviceClass);
            return this;
        }

        public Builder addServiceClasses(Iterable<? extends Class<?>> serviceClasses) {
            this.serviceClasses.addAll(serviceClasses);
            return this;
        }

        public abstract Builder setServiceClasses(ImmutableSet<Class<?>> var1);

        @Deprecated
        public abstract Builder setServletRestricted(boolean var1);

        @Deprecated
        public Builder setRestricted(boolean servletRestricted) {
            return this.setServletRestricted(servletRestricted);
        }

        public abstract Builder setClientIdWhitelistEnabled(boolean var1);

        public abstract Builder setIllegalArgumentBackendError(boolean var1);

        public abstract Builder setExceptionCompatibilityEnabled(boolean var1);

        public abstract Builder setPrettyPrintEnabled(boolean var1);

        abstract ServletInitializationParameters autoBuild();

        public ServletInitializationParameters build() {
            return this.setServiceClasses((ImmutableSet<Class<?>>)this.serviceClasses.build()).autoBuild();
        }
    }
}

