/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.BackendProperties;
import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigLoader;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.annotationreader.ApiConfigAnnotationReader;
import com.google.api.server.spi.config.jsonwriter.JsonConfigWriter;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.discovery.CachingDiscoveryProvider;
import com.google.api.server.spi.discovery.DiscoveryGenerator;
import com.google.api.server.spi.discovery.LocalDiscoveryProvider;
import com.google.api.server.spi.discovery.ProxyingDiscoveryService;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.response.UnauthorizedException;
import endpoints.repackaged.com.google.common.base.Function;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Predicate;
import endpoints.repackaged.com.google.common.collect.ArrayListMultimap;
import endpoints.repackaged.com.google.common.collect.FluentIterable;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SystemService {
    private static final Logger logger = Logger.getLogger(SystemService.class.getName());
    private static final String OAUTH_EXCEPTION_CLASS = "com.google.appengine.api.oauth.OAuthRequestException";
    public static final String MIME_JSON = "application/json; charset=UTF-8";
    public static final int DUPLICATE_SERVICE_REGISTER_COUNT = -1;
    private static final Predicate<ApiConfig> NON_INTERNAL_PREDICATE = new Predicate<ApiConfig>(){

        @Override
        public boolean apply(ApiConfig config) {
            return !"_GoogleCloudEndpointsInternal".equals(config.getName());
        }
    };
    private static final Function<EndpointNode, ApiConfig> ENDPOINT_NODE_TO_API_CONFIG = new Function<EndpointNode, ApiConfig>(){

        @Override
        public ApiConfig apply(EndpointNode node) {
            return node.config;
        }
    };
    private final Map<String, List<Object>> servicesByName = new HashMap<String, List<Object>>();
    private final ConcurrentMap<Object, EndpointNode> endpoints = new ConcurrentHashMap<Object, EndpointNode>();
    private final Map<String, String> serviceApiVersions = new HashMap<String, String>();
    private final Map<String, ApiSerializationConfig> serializationConfigs = new HashMap<String, ApiSerializationConfig>();
    private final Multimap<String, ApiConfig> initialConfigsByApi = ArrayListMultimap.create();
    private final ApiConfigLoader configLoader;
    private final ServiceContext serviceContext;
    private final ApiConfigWriter configWriter;
    private final boolean isIllegalArgumentBackendError;

    public SystemService(ApiConfigLoader configLoader, String appName, ApiConfigWriter configWriter, Object[] services, boolean isIllegalArgumentBackendError) throws ApiConfigException {
        this(configLoader, appName, configWriter, isIllegalArgumentBackendError);
        for (Object service : services) {
            this.registerService(service);
        }
    }

    public SystemService(ApiConfigLoader configLoader, String appName, ApiConfigWriter configWriter, boolean isIllegalArgumentBackendError) throws ApiConfigException {
        this.configLoader = configLoader;
        this.serviceContext = ServiceContext.create(appName, "myapi");
        this.configWriter = configWriter;
        this.isIllegalArgumentBackendError = isIllegalArgumentBackendError;
    }

    public int registerService(Class<?> serviceClass, Object service) throws ApiConfigException {
        Preconditions.checkArgument(serviceClass.isInstance(service), "service is not an instance of " + serviceClass.getName());
        ApiConfig apiConfig = this.configLoader.loadConfiguration(this.serviceContext, serviceClass);
        return this.registerLoadedService(serviceClass, service, apiConfig);
    }

    public int registerService(Object service) throws ApiConfigException {
        Class<Object> serviceClass = SystemService.getServiceClass(service);
        return this.registerService(serviceClass, service);
    }

    private int registerLoadedService(Class<?> serviceClass, Object service, ApiConfig apiConfig) throws ApiConfigException {
        String fullName = serviceClass.getName();
        if (!this.servicesByName.containsKey(fullName)) {
            String api = apiConfig.getName() + "-" + apiConfig.getVersion();
            this.initialConfigsByApi.put(api, apiConfig);
            ApiSerializationConfig serializationConfig = this.serializationConfigs.get(api);
            if (serializationConfig == null) {
                serializationConfig = new ApiSerializationConfig();
            }
            for (ApiSerializationConfig.SerializerConfig rule : apiConfig.getSerializationConfig().getSerializerConfigs()) {
                serializationConfig.addSerializationConfig(rule.getSerializer());
            }
            this.serializationConfigs.put(api, serializationConfig);
            this.registerServiceFromName(service, serviceClass.getSimpleName(), api);
            this.registerServiceFromName(service, fullName, api);
            this.updateEndpointConfig(service, apiConfig, null);
            return apiConfig.getApiClassConfig().getMethods().size();
        }
        return -1;
    }

    public <T> EndpointNode updateEndpointConfig(T endpoint, ApiConfig newConfig, @Nullable EndpointNode oldNode) {
        EndpointNode newNode = new EndpointNode(endpoint, newConfig);
        for (EndpointMethod method : newConfig.getApiClassConfig().getMethods().keySet()) {
            newNode.methods.put(method.getMethod().getName(), method);
        }
        if (oldNode == null) {
            this.endpoints.putIfAbsent(endpoint, newNode);
        } else {
            this.endpoints.replace(endpoint, oldNode, newNode);
        }
        return newNode;
    }

    void registerServiceFromName(final Object service, String name, String api) {
        ArrayList<Object> services = this.servicesByName.get(name);
        if (services == null) {
            services = new ArrayList<Object>(){
                {
                    this.add(service);
                }
            };
            this.servicesByName.put(name, (List<Object>)services);
        } else {
            services.add(service);
        }
        this.serviceApiVersions.put(name, api);
    }

    public EndpointMethod resolveService(String serviceName, String methodName) throws ServiceException {
        return (EndpointMethod)this.getEndpointNode(serviceName).methods.get(methodName);
    }

    private ApiMethodConfig getMethodConfigFromNode(EndpointNode node, String methodName) {
        return (ApiMethodConfig)node.config.getApiClassConfig().getMethods().get(node.methods.get(methodName));
    }

    public ApiSerializationConfig getSerializationConfig(String serviceName) {
        return this.serializationConfigs.get(this.serviceApiVersions.get(serviceName));
    }

    private EndpointNode getEndpointNode(String serviceName) throws ServiceException {
        Object service = this.findService(serviceName);
        EndpointNode node = (EndpointNode)this.endpoints.get(service);
        if (node == null) {
            throw new ServiceException(404, "service '" + serviceName + "' not found");
        }
        return node;
    }

    public Object findService(String name) throws ServiceException {
        List<Object> services = this.servicesByName.get(name);
        if (services == null || services.isEmpty()) {
            throw new ServiceException(404, "service '" + name + "' not found");
        }
        if (services.size() > 1) {
            Class<Object> clazz = SystemService.getServiceClass(services.get(0));
            Preconditions.checkState(name.equals(clazz.getSimpleName()), "Only requested simple class names should result in a collision.");
            StringBuilder builder = new StringBuilder("Two or more Endpoint classes are mapped to the same service name (").append(name).append("):");
            for (Object service : services) {
                builder.append(' ').append(SystemService.getServiceClass(service).getName());
            }
            throw new ServiceException(500, builder.toString());
        }
        Object service = services.get(0);
        logger.log(Level.FINE, "{0} => {1}", new Object[]{name, services.get(0)});
        return service;
    }

    public Method findServiceMethod(Object service, String methodName) throws ServiceException {
        EndpointMethod method;
        EndpointNode endpointNode;
        EndpointNode endpointNode2 = endpointNode = service == null ? null : (EndpointNode)this.endpoints.get(service);
        if (endpointNode != null && (method = (EndpointMethod)endpointNode.methods.get(methodName)) != null) {
            logger.log(Level.FINE, "serviceMethod={0}", method.getMethod());
            return method.getMethod();
        }
        throw new ServiceException(404, "method '" + service + "." + methodName + "' not found");
    }

    public void invokeServiceMethod(Object service, Method method, ParamReader paramReader, ResultWriter resultWriter) throws IOException {
        try {
            Object[] params = paramReader.read();
            logger.log(Level.FINE, "params={0} (String)", Arrays.toString(params));
            Object response = method.invoke(service, params);
            resultWriter.write(response);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.log(Level.SEVERE, "exception occurred while calling backend method", e);
            resultWriter.writeError(new BadRequestException(e));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Level level = Level.INFO;
            if (cause instanceof ServiceException) {
                resultWriter.writeError((ServiceException)cause);
            } else if (cause instanceof IllegalArgumentException) {
                resultWriter.writeError(this.isIllegalArgumentBackendError ? new InternalServerErrorException(cause) : new BadRequestException(cause));
            } else if (SystemService.isOAuthRequestException(cause.getClass())) {
                resultWriter.writeError(new UnauthorizedException(cause));
            } else if (cause.getCause() != null && cause.getCause() instanceof ServiceException) {
                ServiceException serviceException = (ServiceException)cause.getCause();
                level = serviceException.getLogLevel();
                resultWriter.writeError(serviceException);
            } else {
                level = Level.SEVERE;
                resultWriter.writeError(new InternalServerErrorException(cause));
            }
            logger.log(level, "exception occurred while calling backend method", cause);
        }
        catch (ServiceException e) {
            logger.log(e.getLogLevel(), "exception occurred while calling backend method", e);
            resultWriter.writeError(e);
        }
    }

    public Map<ApiKey, String> getApiConfigs() throws ApiConfigException {
        return this.configWriter.writeConfig(FluentIterable.from(this.endpoints.values()).transform(ENDPOINT_NODE_TO_API_CONFIG).filter(NON_INTERNAL_PREDICATE));
    }

    public ImmutableList<EndpointNode> getEndpoints() {
        return ImmutableList.copyOf(this.endpoints.values());
    }

    private void validateRegisteredServices(ApiConfigValidator validator) throws ApiConfigException {
        for (String api : this.initialConfigsByApi.keySet()) {
            validator.validate(this.initialConfigsByApi.get(api));
        }
    }

    private static boolean isOAuthRequestException(Class<?> clazz) {
        while (Object.class != clazz) {
            if (OAUTH_EXCEPTION_CLASS.equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private static <T> Class<? super T> getServiceClass(T service) {
        Class<?> clazz = service.getClass();
        Enhancers[] enhancers = Enhancers.values();
        for (int i = 0; i < enhancers.length; ++i) {
            if (!enhancers[i].matches(clazz)) continue;
            clazz = clazz.getSuperclass();
            i = 0;
        }
        return clazz;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ApiConfigLoader configLoader;
        private TypeLoader typeLoader;
        private ApiConfigValidator configValidator;
        private String appName;
        private ApiConfigWriter configWriter;
        private boolean isIllegalArgumentBackendError;
        private boolean enableDiscoveryService;
        private Map<Class<?>, Object> services = Maps.newLinkedHashMap();
        private SchemaRepository schemaRepository;

        public Builder withDefaults(ClassLoader classLoader) throws ClassNotFoundException {
            this.setStandardConfigLoader(classLoader);
            this.setAppName(new BackendProperties().getApplicationId());
            this.typeLoader = new TypeLoader(classLoader);
            this.isIllegalArgumentBackendError = false;
            this.enableDiscoveryService = false;
            this.setConfigWriter(new JsonConfigWriter(this.typeLoader, this.configValidator));
            this.schemaRepository = new SchemaRepository(this.typeLoader);
            this.setConfigValidator(new ApiConfigValidator(this.typeLoader, this.schemaRepository));
            return this;
        }

        public Builder setStandardConfigLoader(ClassLoader classLoader) throws ClassNotFoundException {
            TypeLoader typeLoader = new TypeLoader(classLoader);
            ApiConfigAnnotationReader annotationReader = new ApiConfigAnnotationReader(typeLoader.getAnnotationTypes());
            this.configLoader = new ApiConfigLoader(new ApiConfig.Factory(), typeLoader, annotationReader, new ApiConfigSource[0]);
            return this;
        }

        public Builder setConfigValidator(ApiConfigValidator configValidator) {
            this.configValidator = configValidator;
            return this;
        }

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setConfigWriter(ApiConfigWriter configWriter) {
            this.configWriter = configWriter;
            return this;
        }

        public Builder setIllegalArgumentIsBackendError(boolean isIllegalArgumentBackendError) {
            this.isIllegalArgumentBackendError = isIllegalArgumentBackendError;
            return this;
        }

        public Builder setDiscoveryServiceEnabled(boolean enableDiscoveryService) {
            this.enableDiscoveryService = enableDiscoveryService;
            return this;
        }

        public Builder addService(Class<?> serviceClass, Object service) {
            this.services.put(serviceClass, service);
            return this;
        }

        public SystemService build() throws ApiConfigException {
            Preconditions.checkNotNull(this.configLoader, "configLoader");
            Preconditions.checkNotNull(this.configValidator, "configValidator");
            Preconditions.checkNotNull(this.configWriter, "configWriter");
            SystemService systemService = new SystemService(this.configLoader, this.appName, this.configWriter, this.isIllegalArgumentBackendError);
            for (Map.Entry<Class<?>, Object> entry : this.services.entrySet()) {
                systemService.registerService(entry.getKey(), entry.getValue());
            }
            if (this.enableDiscoveryService) {
                ProxyingDiscoveryService discoveryService = new ProxyingDiscoveryService();
                systemService.registerService(discoveryService);
                discoveryService.initialize(new CachingDiscoveryProvider(new LocalDiscoveryProvider(this.getApiConfigs(systemService), new DiscoveryGenerator(this.typeLoader), this.schemaRepository)));
            }
            systemService.validateRegisteredServices(this.configValidator);
            return systemService;
        }

        private ImmutableList<ApiConfig> getApiConfigs(SystemService systemService) {
            ApiConfig.Factory factory = new ApiConfig.Factory();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (EndpointNode node : systemService.getEndpoints()) {
                if (!node.isExternalEndpoint()) continue;
                builder.add(factory.copy(node.getConfig()));
            }
            return builder.build();
        }
    }

    private static enum Enhancers {
        GUICE("$$EnhancerByGuice$$"),
        NONE(null);

        private final String enhancerSubstring;

        private Enhancers(String enhancerSubstring) {
            this.enhancerSubstring = enhancerSubstring;
        }

        public boolean matches(Class<?> clazz) {
            return this.enhancerSubstring != null && clazz.getSimpleName().contains(this.enhancerSubstring);
        }
    }

    public static class EndpointNode {
        private final Object endpoint;
        private final ApiConfig config;
        private final Map<String, EndpointMethod> methods;

        EndpointNode(Object endpoint, ApiConfig config) {
            this.endpoint = endpoint;
            this.config = config;
            this.methods = new HashMap<String, EndpointMethod>();
        }

        public Object getEndpoint() {
            return this.endpoint;
        }

        public ApiConfig getConfig() {
            return this.config;
        }

        public boolean isExternalEndpoint() {
            return !"_GoogleCloudEndpointsInternal".equals(this.config.getName());
        }

        public Map<String, EndpointMethod> getMethods() {
            return this.methods;
        }
    }
}

