/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiLimitMetric;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiIssuerConfigs;
import com.google.api.server.spi.config.model.ApiLimitMetricConfig;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

class ApiAnnotationConfig {
    private final ApiConfig config;

    public ApiAnnotationConfig(ApiConfig config) {
        this.config = config;
    }

    public ApiConfig getConfig() {
        return this.config;
    }

    public void setRootIfNotEmpty(String root) {
        if (!Strings.isNullOrEmpty(root)) {
            this.config.setRoot(root);
        }
    }

    public void setNameIfNotEmpty(String name) {
        if (!Strings.isNullOrEmpty(name)) {
            this.config.setName(name);
        }
    }

    public void setCanonicalNameIfNotEmpty(String canonicalName) {
        if (!Strings.isNullOrEmpty(canonicalName)) {
            this.config.setCanonicalName(canonicalName);
        }
    }

    public void setVersionIfNotEmpty(String version) {
        if (!Strings.isNullOrEmpty(version)) {
            this.config.setVersion(version);
        }
    }

    public void setTitleIfNotEmpty(String title) {
        if (!Strings.isNullOrEmpty(title)) {
            this.config.setTitle(title);
        }
    }

    public void setDescriptionIfNotEmpty(String description) {
        if (!Strings.isNullOrEmpty(description)) {
            this.config.setDescription(description);
        }
    }

    public void setDocumentationLinkIfNotEmpty(String documentationLink) {
        if (!Strings.isNullOrEmpty(documentationLink)) {
            this.config.setDocumentationLink(documentationLink);
        }
    }

    public void setBackendRootIfNotEmpty(String backendRoot) {
        if (!Strings.isNullOrEmpty(backendRoot)) {
            this.config.setBackendRoot(backendRoot);
        }
    }

    public void setIsAbstractIfSpecified(AnnotationBoolean isAbstract) {
        if (isAbstract == AnnotationBoolean.TRUE) {
            this.config.setIsAbstract(true);
        } else if (isAbstract == AnnotationBoolean.FALSE) {
            this.config.setIsAbstract(false);
        }
    }

    public void setIsDefaultVersionIfSpecified(AnnotationBoolean defaultVersion) {
        if (defaultVersion == AnnotationBoolean.TRUE) {
            this.config.setIsDefaultVersion(true);
        } else if (defaultVersion == AnnotationBoolean.FALSE) {
            this.config.setIsDefaultVersion(false);
        }
    }

    public void setIsDiscoverableIfSpecified(AnnotationBoolean discoverable) {
        if (discoverable == AnnotationBoolean.TRUE) {
            this.config.setIsDiscoverable(true);
        } else if (discoverable == AnnotationBoolean.FALSE) {
            this.config.setIsDiscoverable(false);
        }
    }

    public void setUseDatastoreIfSpecified(AnnotationBoolean useDatastore) {
        if (useDatastore == AnnotationBoolean.TRUE) {
            this.config.setUseDatastore(true);
        } else if (useDatastore == AnnotationBoolean.FALSE) {
            this.config.setUseDatastore(false);
        }
    }

    public void setResourceIfNotEmpty(String resource) {
        if (!resource.isEmpty()) {
            this.config.setResource(resource);
        }
    }

    public void setAuthLevelIfSpecified(AuthLevel authLevel) {
        if (authLevel != AuthLevel.UNSPECIFIED) {
            this.config.setAuthLevel(authLevel);
        }
    }

    public void setScopesIfSpecified(String[] scopes) {
        if (!AnnotationUtil.isUnspecified(scopes)) {
            this.config.setScopeExpression(AuthScopeExpressions.interpret(scopes));
        }
    }

    public void setAudiencesIfSpecified(String[] audiences) {
        if (!AnnotationUtil.isUnspecified(audiences)) {
            this.config.setAudiences(Arrays.asList(audiences));
        }
    }

    public void setIssuersIfSpecified(ApiIssuerConfigs issuers) {
        if (issuers.isSpecified()) {
            this.config.setIssuers(issuers);
        }
    }

    public void setIssuerAudiencesIfSpecified(ApiIssuerAudienceConfig issuerAudiences) {
        if (issuerAudiences.isSpecified()) {
            this.config.setIssuerAudiences(issuerAudiences);
        }
    }

    public void setClientIdsIfSpecified(String[] clientIds) {
        if (!AnnotationUtil.isUnspecified(clientIds)) {
            this.config.setClientIds(Arrays.asList(clientIds));
        }
    }

    public void setAuthenticatorsIfSpecified(Class<? extends Authenticator>[] authenticators) {
        if (!AnnotationUtil.isUnspecified(authenticators)) {
            this.config.setAuthenticators(Arrays.asList(authenticators));
        }
    }

    public void setPeerAuthenticatorsIfSpecified(Class<? extends PeerAuthenticator>[] peerAuthenticators) {
        if (!AnnotationUtil.isUnspecifiedPeerAuthenticators(peerAuthenticators)) {
            this.config.setPeerAuthenticators(Arrays.asList(peerAuthenticators));
        }
    }

    public void setApiKeyRequiredIfSpecified(AnnotationBoolean apiKeyRequired) {
        if (apiKeyRequired == AnnotationBoolean.TRUE) {
            this.config.setApiKeyRequired(true);
        } else if (apiKeyRequired == AnnotationBoolean.FALSE) {
            this.config.setApiKeyRequired(false);
        }
    }

    public void setApiLimitMetrics(ApiLimitMetric[] apiLimitMetrics) {
        ImmutableList.Builder metricConfigs = ImmutableList.builder();
        if (apiLimitMetrics != null && apiLimitMetrics.length > 0) {
            for (ApiLimitMetric metric : apiLimitMetrics) {
                metricConfigs.add(ApiLimitMetricConfig.builder().setName(metric.name()).setDisplayName(metric.displayName()).setLimit(metric.limit()).build());
            }
        }
        this.config.setApiLimitMetrics((List<ApiLimitMetricConfig>)((Object)metricConfigs.build()));
    }
}

