/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiResourceProperty;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.Serializers;
import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonAutoDetect;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonParser;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonToken;
import endpoints.repackaged.com.fasterxml.jackson.core.type.TypeReference;
import endpoints.repackaged.com.fasterxml.jackson.databind.DeserializationContext;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonDeserializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonSerializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.PropertyName;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializerProvider;
import endpoints.repackaged.com.fasterxml.jackson.databind.introspect.Annotated;
import endpoints.repackaged.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import endpoints.repackaged.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import endpoints.repackaged.com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import endpoints.repackaged.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ApiAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final ApiSerializationConfig config;

    public ApiAnnotationIntrospector() {
        this(new ApiSerializationConfig());
    }

    public ApiAnnotationIntrospector(ApiSerializationConfig config) {
        this.config = config;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember member) {
        ApiResourceProperty apiProperty = member.getAnnotation(ApiResourceProperty.class);
        return apiProperty != null && apiProperty.ignored() == AnnotationBoolean.TRUE;
    }

    @Override
    public PropertyName findNameForSerialization(Annotated a) {
        ApiResourceProperty apiName = a.getAnnotation(ApiResourceProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return PropertyName.construct(apiName.name());
        }
        return null;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated a) {
        ApiResourceProperty annotation = this.findAnnotation(a);
        return annotation != null ? PropertyName.construct(annotation.name()) : null;
    }

    @Override
    public String findPropertyDescription(Annotated a) {
        ApiResourceProperty annotation = this.findAnnotation(a);
        return annotation != null ? annotation.description() : null;
    }

    private ApiResourceProperty findAnnotation(Annotated a) {
        ApiResourceProperty annotation = a.getAnnotation(ApiResourceProperty.class);
        return annotation != null && annotation.ignored() != AnnotationBoolean.TRUE ? annotation : null;
    }

    @Override
    public JsonSerializer<?> findSerializer(Annotated method) {
        return ApiAnnotationIntrospector.getJsonSerializer(this.findSerializerInstance(method));
    }

    @Override
    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    @Nullable
    private static <TFrom, TTo> JsonSerializer<TFrom> getJsonSerializer(final @Nullable Transformer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        return new JsonSerializer<TFrom>(){

            @Override
            public void serialize(TFrom value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeObject(serializer.transformTo(value));
            }
        };
    }

    @Override
    public JsonDeserializer<?> findDeserializer(Annotated a) {
        return ApiAnnotationIntrospector.getJsonDeserializer(this.findSerializerInstance(a));
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        return checker.withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
    }

    private static <TFrom, TTo> JsonDeserializer<TFrom> getJsonDeserializer(final @Nullable Transformer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        final TypeReference<TTo> serializedType = ApiAnnotationIntrospector.typeReferenceOf(serializer);
        if (serializer instanceof ResourceTransformer) {
            ResourceTransformer resourceSerializer = (ResourceTransformer)serializer;
            return new ResourceDeserializer(resourceSerializer);
        }
        return new JsonDeserializer<TFrom>(){

            @Override
            public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                Object deserialized = jp.readValueAs(serializedType);
                return serializer.transformFrom(deserialized);
            }
        };
    }

    public static TypeToken<?> getSchemaType(TypeToken<?> type, ApiConfig config) {
        List<Class<Transformer<?, ?>>> serializers;
        Type rawType = type.getType();
        if ((rawType instanceof Class || rawType instanceof ParameterizedType) && !(serializers = Serializers.getSerializerClasses(type, config.getSerializationConfig())).isEmpty() && !ResourceTransformer.class.isAssignableFrom(serializers.get(0))) {
            TypeToken<?> sourceType = Serializers.getSourceType(serializers.get(0));
            TypeToken<?> serializedType = Serializers.getTargetType(serializers.get(0));
            Preconditions.checkArgument(sourceType.isSupertypeOf(type), "Serializer specified for %s, but only serializes for %s: %s", type, sourceType, serializers.get(0));
            Preconditions.checkArgument(serializedType != null, "Couldn't find Serializer interface in serializer for %s: %s", type, serializers.get(0));
            return serializedType;
        }
        return type;
    }

    @Nullable
    private Transformer<?, ?> findSerializerInstance(Annotated a) {
        AnnotatedClass clazz;
        List<Class<Transformer<?, ?>>> serializerClasses;
        if (a instanceof AnnotatedClass && !(serializerClasses = Serializers.getSerializerClasses((clazz = (AnnotatedClass)a).getRawType(), this.config)).isEmpty()) {
            return Serializers.instantiate(serializerClasses.get(0), TypeToken.of(a.getRawType()));
        }
        return null;
    }

    private static <T> TypeReference<T> typeReferenceOf(Transformer<?, T> serializer) {
        Class<?> serializerClass = serializer.getClass();
        final TypeToken<?> type = Serializers.getTargetType(serializerClass);
        return new TypeReference<T>(){

            @Override
            public Type getType() {
                return type.getType();
            }
        };
    }

    private static class ResourceDeserializer<TFrom>
    extends JsonDeserializer<TFrom> {
        private final ResourceTransformer<TFrom> resourceSerializer;

        private ResourceDeserializer(ResourceTransformer<TFrom> resourceSerializer) {
            this.resourceSerializer = resourceSerializer;
        }

        @Override
        public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map<String, ResourcePropertySchema> properties = this.resourceSerializer.getResourceSchema().getProperties();
            ImmutableMap.Builder values = ImmutableMap.builder();
            while (jp.nextValue() != JsonToken.END_OBJECT) {
                String property = jp.getCurrentName();
                final ResourcePropertySchema schemaType = properties.get(property);
                if (schemaType != null) {
                    TypeReference<Object> jacksonTypeRef = new TypeReference<Object>(){

                        @Override
                        public Type getType() {
                            return schemaType.getJavaType();
                        }
                    };
                    values.put(property, jp.readValueAs(jacksonTypeRef));
                }
                jp.skipChildren();
            }
            return this.resourceSerializer.transformFrom(values.build());
        }
    }
}

