/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import java.util.Objects;

public class ApiIssuerConfigs {
    static final String UNSPECIFIED_NAME = "_unspecified_issuer_name";
    public static final IssuerConfig GOOGLE_ID_TOKEN_ISSUER = new IssuerConfig("google_id_token", "accounts.google.com", "https://www.googleapis.com/oauth2/v1/certs");
    public static final IssuerConfig GOOGLE_ID_TOKEN_ISSUER_ALT = new IssuerConfig("google_id_token_https", "https://accounts.google.com", "https://www.googleapis.com/oauth2/v1/certs");
    public static final ApiIssuerConfigs UNSPECIFIED = ApiIssuerConfigs.builder().addIssuer(new IssuerConfig("_unspecified_issuer_name", null, null)).build();
    public static final ApiIssuerConfigs EMPTY = ApiIssuerConfigs.builder().build();
    private final ImmutableMap<String, IssuerConfig> issuerConfigs;

    private ApiIssuerConfigs(Builder builder) {
        this.issuerConfigs = builder.issuerConfigs.build();
    }

    public ImmutableMap<String, IssuerConfig> asMap() {
        return this.issuerConfigs;
    }

    public boolean hasIssuer(String issuer) {
        return this.issuerConfigs.containsKey(issuer);
    }

    public IssuerConfig getIssuer(String issuer) {
        return this.issuerConfigs.get(issuer);
    }

    public boolean isSpecified() {
        return !this.equals(UNSPECIFIED);
    }

    public ApiIssuerConfigs withGoogleIdToken() {
        if (this.hasIssuer("google_id_token") && this.hasIssuer("google_id_token_https")) {
            return this;
        }
        Builder builder = ApiIssuerConfigs.builder();
        if (this.isSpecified()) {
            builder.issuerConfigs.putAll(this.issuerConfigs);
        }
        builder.addIssuer(GOOGLE_ID_TOKEN_ISSUER);
        builder.addIssuer(GOOGLE_ID_TOKEN_ISSUER_ALT);
        return builder.build();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ApiIssuerConfigs && this.issuerConfigs.equals(((ApiIssuerConfigs)o).issuerConfigs);
    }

    public int hashCode() {
        return this.issuerConfigs.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, IssuerConfig> issuerConfigs = ImmutableMap.builder();

        public Builder addIssuer(IssuerConfig issuer) {
            this.issuerConfigs.put(issuer.getName(), issuer);
            return this;
        }

        public ApiIssuerConfigs build() {
            return new ApiIssuerConfigs(this);
        }
    }

    public static class IssuerConfig {
        private final String name;
        private final String issuer;
        private final String jwksUri;

        public IssuerConfig(String name, String issuer, String jwksUri) {
            this.name = name;
            this.issuer = issuer;
            this.jwksUri = jwksUri;
        }

        public String getName() {
            return this.name;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public String getJwksUri() {
            return this.jwksUri;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof IssuerConfig && Objects.equals(this.name, ((IssuerConfig)o).name) && Objects.equals(this.issuer, ((IssuerConfig)o).issuer) && Objects.equals(this.jwksUri, ((IssuerConfig)o).jwksUri);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

