/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.ApiTransformer;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import endpoints.repackaged.com.google.common.base.Joiner;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.Lists;
import endpoints.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class Serializers {
    private Serializers() {
    }

    public static <S extends Transformer<?, ?>> S instantiate(Class<S> serializerClass, TypeToken<?> sourceType) {
        if (!Serializers.getSourceType(serializerClass).isSupertypeOf(sourceType)) {
            throw new IllegalArgumentException(String.format("Can not instantiate %s, the serializer source %s is not assignable from %s", serializerClass, Serializers.getSourceType(serializerClass), sourceType));
        }
        for (SerializerConstructor constructor : SerializerConstructor.values()) {
            try {
                return constructor.construct(serializerClass, sourceType.getType());
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to instantiate custom serializer constructor %s%s with source type: %s", new Object[]{serializerClass.getName(), constructor, sourceType});
                throw new IllegalStateException(errorMessage, e);
            }
        }
        String message = String.format("Failed to instantiate custom serializer %s, constructors not found: %s", serializerClass.getName(), Arrays.toString((Object[])SerializerConstructor.values()));
        throw new IllegalStateException(message);
    }

    public static List<Class<? extends Transformer<?, ?>>> getSerializerClasses(@Nullable Type type, @Nullable ApiSerializationConfig config) {
        if (type == null) {
            return Collections.emptyList();
        }
        return Serializers.getSerializerClasses(TypeToken.of(type), config);
    }

    public static List<Class<? extends Transformer<?, ?>>> getSerializerClasses(TypeToken<?> type, @Nullable ApiSerializationConfig config) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<Class<Transformer<?, ?>>> allParentSerializers = Lists.newArrayList();
        ArrayList<TypeToken<?>> serializedTypes = Lists.newArrayList();
        for (TypeToken typeToken : type.getTypes()) {
            ApiSerializationConfig.SerializerConfig serializerConfig;
            ApiTransformer apiSerialization = typeToken.getRawType().getAnnotation(ApiTransformer.class);
            if (Serializers.isSupertypeOf(typeToken, serializedTypes)) continue;
            if (apiSerialization != null) {
                allParentSerializers.add(apiSerialization.value());
                serializedTypes.add(typeToken);
                continue;
            }
            if (config == null || (serializerConfig = config.getSerializerConfig(typeToken)) == null) continue;
            allParentSerializers.add(serializerConfig.getSerializer());
            serializedTypes.add(typeToken);
        }
        return allParentSerializers;
    }

    @Nullable
    public static TypeToken<?> getSourceType(Class<? extends Transformer<?, ?>> clazz) {
        try {
            TypeToken<Transformer<?, ?>> token = TypeToken.of(clazz);
            return token.resolveType(Transformer.class.getMethod("transformFrom", Object.class).getGenericReturnType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static TypeToken<?> getTargetType(Class<? extends Transformer<?, ?>> clazz) {
        try {
            TypeToken<Transformer<?, ?>> token = TypeToken.of(clazz);
            return token.resolveType(Transformer.class.getMethod("transformTo", Object.class).getGenericReturnType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static ParameterizedType getResolvedType(@Nullable Class<? extends Transformer<?, ?>> clazz) {
        if (clazz == null || !Transformer.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (TypeToken token : TypeToken.of(clazz).getTypes().interfaces()) {
            if (!token.getRawType().equals(Transformer.class)) continue;
            Type tokenType = token.getType();
            return tokenType instanceof ParameterizedType ? (ParameterizedType)tokenType : null;
        }
        return null;
    }

    private static boolean isSupertypeOf(TypeToken<?> typeToken, List<TypeToken<?>> subtypes) {
        for (TypeToken<?> subType : subtypes) {
            if (!typeToken.isSupertypeOf(subType)) continue;
            return true;
        }
        return false;
    }

    private static enum SerializerConstructor {
        TYPE{

            @Override
            <S extends Transformer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                return (S)((Transformer)serializerClass.getDeclaredConstructor(Type.class).newInstance(sourceType));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of(Type.class);
            }
        }
        ,
        CLASS{

            @Override
            <S extends Transformer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                Class<?> sourceClass = TypeToken.of(sourceType).getRawType();
                return (S)((Transformer)serializerClass.getDeclaredConstructor(Class.class).newInstance(sourceClass));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of(Class.class);
            }
        }
        ,
        DEFAULT{

            @Override
            <S extends Transformer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                return (S)((Transformer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of();
            }
        };


        abstract <S extends Transformer<?, ?>> S construct(Class<S> var1, Type var2) throws Exception;

        abstract ImmutableList<Type> getArgs();

        public String toString() {
            return String.format("(%s)", Joiner.on(", ").join(this.getArgs()));
        }
    }
}

