/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.EndpointsContext;
import endpoints.repackaged.com.google.common.collect.ImmutableSet;
import javax.servlet.http.HttpServletRequest;

public final class StandardParameters {
    public static final String ALT = "alt";
    public static final String FIELDS = "fields";
    public static final String KEY = "key";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String PRETTY_PRINT = "prettyPrint";
    public static final String QUOTA_USER = "quotaUser";
    public static final String USER_IP = "userIp";
    public static final ImmutableSet<String> STANDARD_PARAM_NAMES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add("alt")).add("fields")).add("key")).add("oauth_token")).add("prettyPrint")).add("quotaUser")).add("userIp")).build();

    private StandardParameters() {
    }

    public static boolean isStandardParamName(String paramName) {
        return STANDARD_PARAM_NAMES.contains(paramName);
    }

    public static boolean shouldPrettyPrint(EndpointsContext context) {
        HttpServletRequest request = context.getRequest();
        String prettyPrintStr = request.getParameter(PRETTY_PRINT);
        if (prettyPrintStr == null) {
            return context.isPrettyPrintEnabled();
        }
        return "true".equals(prettyPrintStr.toLowerCase());
    }
}

