/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.FieldType;
import com.google.api.server.spi.config.model.Serializers;
import com.google.api.server.spi.response.CollectionResponse;
import endpoints.repackaged.com.google.api.client.util.GenericData;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import endpoints.repackaged.com.google.common.collect.Iterables;
import endpoints.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;

public abstract class Types {
    public static boolean isArrayType(TypeToken<?> type) {
        return Types.getArrayItemType(type) != null && !type.isSubtypeOf((Type)((Object)byte[].class));
    }

    public static boolean isEnumType(TypeToken<?> type) {
        return type.isSubtypeOf((Type)((Object)Enum.class));
    }

    public static boolean isMapType(TypeToken<?> type) {
        return type.isSubtypeOf((Type)((Object)Map.class)) && !Types.isJavaClientEntity(type);
    }

    public static boolean isJavaClientEntity(TypeToken<?> type) {
        return type.isSubtypeOf((Type)((Object)GenericData.class));
    }

    public static boolean isTypeVariable(TypeToken<?> type) {
        return type.getType() instanceof TypeVariable;
    }

    public static boolean isCollectionResponseType(TypeToken<?> type) {
        return type.isSubtypeOf((Type)((Object)CollectionResponse.class));
    }

    public static boolean isWildcardType(TypeToken<?> type) {
        Type javaType = type.getType();
        return javaType instanceof WildcardType || javaType instanceof TypeVariable && ((TypeVariable)javaType).getName().startsWith("capture");
    }

    public static boolean isObject(TypeToken<?> type) {
        return type.getType() == Object.class;
    }

    public static String getSimpleName(TypeToken<?> type, ApiSerializationConfig config) {
        ResourceTransformer resourceSerializer;
        ResourceSchema resourceSchema;
        if (type == null) {
            return null;
        }
        TypeToken<?> itemType = Types.getArrayItemType(type);
        if (itemType != null) {
            return Types.getSimpleName(itemType, config) + "Collection";
        }
        if (type.getType() instanceof ParameterizedType) {
            Class<?> clazz = type.getRawType();
            StringBuilder builder = new StringBuilder();
            builder.append(clazz.getSimpleName());
            for (TypeVariable<Class<?>> typeArg : clazz.getTypeParameters()) {
                builder.append('_');
                builder.append(Types.getSimpleName(type.resolveType(typeArg), config));
            }
            return builder.toString();
        }
        Class serializerClass = Iterables.getOnlyElement(Serializers.getSerializerClasses(type, config), null);
        if (serializerClass != null && ResourceTransformer.class.isAssignableFrom(serializerClass) && (resourceSchema = (resourceSerializer = (ResourceTransformer)Serializers.instantiate(serializerClass, type)).getResourceSchema()) != null && resourceSchema.getName() != null) {
            return resourceSchema.getName();
        }
        String collectionName = FieldType.fromType(type).getCollectionName();
        return collectionName != null ? collectionName : type.getRawType().getSimpleName();
    }

    public static TypeToken<?> getArrayItemType(TypeToken<?> type) {
        if (type.isSubtypeOf((Type)((Object)Collection.class))) {
            return type.resolveType(Collection.class.getTypeParameters()[0]);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static TypeToken<?> getTypeParameter(TypeToken<?> type, int index) {
        Preconditions.checkArgument(type.getType() instanceof ParameterizedType, "type is not parameterized");
        Type[] typeArgs = ((ParameterizedType)type.getType()).getActualTypeArguments();
        if (typeArgs.length <= index) {
            throw new IndexOutOfBoundsException(String.format("type '%s' has %d <= %d type arguments", type, typeArgs.length, index));
        }
        return type.resolveType(typeArgs[index]);
    }
}

