/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.scope;

import com.google.api.server.spi.config.scope.AbstractAuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import com.google.api.server.spi.config.scope.SingleAuthScopeExpression;
import endpoints.repackaged.com.google.common.base.Function;
import endpoints.repackaged.com.google.common.base.Joiner;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.Iterables;
import endpoints.repackaged.com.google.common.collect.Lists;
import endpoints.repackaged.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ConjunctAuthScopeExpression
extends AbstractAuthScopeExpression {
    private final ImmutableList<SingleAuthScopeExpression> innerExpressions;

    ConjunctAuthScopeExpression(List<SingleAuthScopeExpression> innerExpressions) {
        this.innerExpressions = ImmutableList.copyOf(innerExpressions);
    }

    @Override
    public String[] getAllScopes() {
        HashSet<String> allScopes = Sets.newHashSet();
        for (AuthScopeExpression authScopeExpression : this.innerExpressions) {
            allScopes.addAll(Arrays.asList(authScopeExpression.getAllScopes()));
        }
        return allScopes.toArray(new String[allScopes.size()]);
    }

    @Override
    public boolean isAuthorized(Set<String> userScopes) {
        if (this.innerExpressions.isEmpty()) {
            return false;
        }
        for (AuthScopeExpression authScopeExpression : this.innerExpressions) {
            if (authScopeExpression.isAuthorized(userScopes)) continue;
            return false;
        }
        return true;
    }

    @Override
    List<String> encode() {
        return ImmutableList.of(this.doEncode());
    }

    @Override
    List<String> encodeMutable() {
        return Lists.newArrayList(this.doEncode());
    }

    @Override
    public String toLoggingForm() {
        return "(" + Joiner.on(" && ").join(Iterables.transform(this.innerExpressions, new Function<AuthScopeExpression, String>(){

            @Override
            public String apply(AuthScopeExpression scopeExpression) {
                return scopeExpression.toLoggingForm();
            }
        })) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ConjunctAuthScopeExpression)) {
            return false;
        }
        ConjunctAuthScopeExpression that = (ConjunctAuthScopeExpression)obj;
        return this.innerExpressions.equals(that.innerExpressions);
    }

    public int hashCode() {
        return this.innerExpressions.hashCode();
    }

    private String doEncode() {
        ArrayList<String> scopes = Lists.newArrayList();
        for (SingleAuthScopeExpression innerExpression : this.innerExpressions) {
            scopes.add(innerExpression.getScope());
        }
        return AuthScopeExpressions.CONJUNCT_SCOPE_JOINER.join(scopes);
    }
}

