/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.scope;

import com.google.api.server.spi.config.scope.AbstractAuthScopeExpression;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;

class SingleAuthScopeExpression
extends AbstractAuthScopeExpression {
    private final String scope;

    SingleAuthScopeExpression(String scope) {
        this.scope = Preconditions.checkNotNull(scope);
    }

    @Override
    public String[] getAllScopes() {
        return new String[]{this.scope};
    }

    @Override
    public boolean isAuthorized(Set<String> userScopes) {
        return userScopes.contains(this.scope);
    }

    String getScope() {
        return this.scope;
    }

    @Override
    List<String> encode() {
        return ImmutableList.of(this.scope);
    }

    @Override
    List<String> encodeMutable() {
        return Lists.newArrayList(this.scope);
    }

    @Override
    public String toLoggingForm() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SingleAuthScopeExpression)) {
            return false;
        }
        SingleAuthScopeExpression that = (SingleAuthScopeExpression)obj;
        return this.scope.equals(that.scope);
    }

    public int hashCode() {
        return this.scope.hashCode();
    }
}

