/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.validation;

import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.validation.ApiConfigInvalidException;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.collect.Iterables;

public class InconsistentApiConfigurationException
extends ApiConfigInvalidException {
    public InconsistentApiConfigurationException(ApiConfig config, ApiConfig otherConfig, Iterable<ApiConfigInconsistency<Object>> inconsistencies) {
        super(config, InconsistentApiConfigurationException.getErrorMessage(config, otherConfig, inconsistencies));
    }

    private static String getErrorMessage(ApiConfig config, ApiConfig otherConfig, Iterable<ApiConfigInconsistency<Object>> inconsistencies) {
        Preconditions.checkArgument(!Iterables.isEmpty(inconsistencies));
        ApiConfigInconsistency firstInconsistency = Iterables.getFirst(inconsistencies, null);
        return String.format("API-wide configuration does not match between the classes %s and %s. All API classes with the same API name and version must have the exact same API-wide configuration. Differing property: %s (%s vs %s).", config.getApiClassConfig().getApiClassJavaName(), otherConfig.getApiClassConfig().getApiClassJavaName(), firstInconsistency.getPropertyName(), firstInconsistency.getValue1(), firstInconsistency.getValue2());
    }
}

