/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.dispatcher;

import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import java.util.Map;

public class DispatcherContext {
    private final String httpMethod;
    private final String path;
    private ImmutableMap<String, String> rawPathParameters = ImmutableMap.of();

    public DispatcherContext(String httpMethod, String path) {
        this.httpMethod = Preconditions.checkNotNull(httpMethod, "httpMethod").toUpperCase();
        this.path = Preconditions.checkNotNull(path);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public ImmutableMap<String, String> getRawPathParameters() {
        return this.rawPathParameters;
    }

    public void setRawPathParameters(Map<String, String> rawPathParameters) {
        this.rawPathParameters = ImmutableMap.copyOf(rawPathParameters);
    }
}

