/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.dispatcher;

import com.google.api.server.spi.dispatcher.HttpMethod;
import endpoints.repackaged.com.google.common.base.CharMatcher;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Splitter;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathTrie<T> {
    private static final Logger log = Logger.getLogger(PathTrie.class.getName());
    private static final Splitter PATH_SPLITTER = Splitter.on('/');
    private static final String PARAMETER_PATH_SEGMENT = "{}";
    private static final Pattern PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_\\d]*");
    private static final CharMatcher RESERVED_URL_CHARS = CharMatcher.anyOf(":/?#[]{}");
    private final ImmutableMap<String, PathTrie<T>> subTries;
    private final ImmutableMap<HttpMethod, MethodInfo<T>> httpMethodMap;

    private PathTrie(Builder<T> builder) {
        this.httpMethodMap = ImmutableMap.copyOf(((Builder)builder).httpMethodMap);
        ImmutableMap.Builder subTriesBuilder = ImmutableMap.builder();
        for (Map.Entry entry : ((Builder)builder).subBuilders.entrySet()) {
            subTriesBuilder.put(entry.getKey(), new PathTrie<T>((Builder)entry.getValue()));
        }
        this.subTries = subTriesBuilder.build();
    }

    public Result<T> resolve(HttpMethod method, String path) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(path, "path");
        return this.resolve(method, PathTrie.getPathSegments(path), 0, new ArrayList<String>());
    }

    private Result<T> resolve(HttpMethod method, List<String> pathSegments, int index, List<String> rawParameters) {
        if (index < pathSegments.size()) {
            Result<T> result;
            String segment = pathSegments.get(index);
            PathTrie<T> subTrie = this.subTries.get(segment);
            if (subTrie != null && (result = super.resolve(method, pathSegments, index + 1, rawParameters)) != null) {
                return result;
            }
            subTrie = this.subTries.get(PARAMETER_PATH_SEGMENT);
            if (subTrie != null) {
                rawParameters.add(segment);
                result = super.resolve(method, pathSegments, index + 1, rawParameters);
                if (result == null) {
                    rawParameters.remove(rawParameters.size() - 1);
                }
                return result;
            }
            return null;
        }
        if (this.httpMethodMap.containsKey((Object)method)) {
            MethodInfo<T> methodInfo = this.httpMethodMap.get((Object)method);
            ImmutableList parameterNames = ((MethodInfo)methodInfo).parameterNames;
            Preconditions.checkState(rawParameters.size() == parameterNames.size());
            HashMap<String, String> rawParameterMap = Maps.newHashMap();
            for (int i = 0; i < parameterNames.size(); ++i) {
                rawParameterMap.put((String)parameterNames.get(i), PathTrie.decodeUri(rawParameters.get(i)));
            }
            return new Result<Object>(((MethodInfo)methodInfo).value, rawParameterMap);
        }
        return null;
    }

    public static <T> Builder<T> builder() {
        return new Builder(true);
    }

    public static <T> Builder<T> builder(boolean throwOnConflict) {
        return new Builder(throwOnConflict);
    }

    private static List<String> getPathSegments(String path) {
        return PATH_SPLITTER.splitToList(path);
    }

    private static String decodeUri(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private static class MethodInfo<T> {
        private final ImmutableList<String> parameterNames;
        private final T value;

        MethodInfo(List<String> parameterNames, T value) {
            this.parameterNames = ImmutableList.copyOf(parameterNames);
            this.value = value;
        }
    }

    public static class Builder<T> {
        private final Map<String, Builder<T>> subBuilders = Maps.newHashMap();
        private final Map<HttpMethod, MethodInfo<T>> httpMethodMap = new EnumMap<HttpMethod, MethodInfo<T>>(HttpMethod.class);
        private final boolean throwOnConflict;

        public Builder(boolean throwOnConflict) {
            this.throwOnConflict = throwOnConflict;
        }

        public Builder<T> add(HttpMethod method, String path, T value) {
            Preconditions.checkNotNull(method, "method");
            Preconditions.checkNotNull(path, "path");
            Preconditions.checkNotNull(value, "value");
            this.add(method, path, PathTrie.getPathSegments(path).iterator(), value, new ArrayList<String>());
            return this;
        }

        public PathTrie<T> build() {
            return new PathTrie(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void add(HttpMethod method, String path, Iterator<String> pathSegments, T value, List<String> parameterNames) {
            if (pathSegments.hasNext()) {
                String segment = pathSegments.next();
                if (segment.startsWith("{")) {
                    if (!segment.endsWith("}")) throw new IllegalArgumentException(String.format("'%s' contains invalid parameter syntax: %s", path, segment));
                    parameterNames.add(this.getAndCheckParameterName(segment));
                    super.add(method, path, pathSegments, value, parameterNames);
                    return;
                } else {
                    if (RESERVED_URL_CHARS.matchesAnyOf(segment)) {
                        throw new IllegalArgumentException(String.format("'%s' contains invalid path segment: %s", path, segment));
                    }
                    super.add(method, path, pathSegments, value, parameterNames);
                }
                return;
            } else {
                boolean pathExists = this.httpMethodMap.containsKey((Object)method);
                if (pathExists && this.throwOnConflict) {
                    throw new IllegalArgumentException(String.format("Path '%s' is already mapped", path));
                }
                if (pathExists) {
                    log.warning(String.format("Path '%s' is already mapped, but overwriting it", path));
                }
                this.httpMethodMap.put(method, new MethodInfo<T>(parameterNames, value));
            }
        }

        private String getAndCheckParameterName(String segment) {
            String name = segment.substring(1, segment.length() - 1);
            Matcher matcher = PARAMETER_NAME_PATTERN.matcher(name);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("'%s' not a valid path parameter name", name));
            }
            return name;
        }

        private Builder<T> getOrCreateSubBuilder(String segment) {
            Builder<T> subBuilder = this.subBuilders.get(segment);
            if (subBuilder == null) {
                subBuilder = PathTrie.builder(this.throwOnConflict);
                this.subBuilders.put(segment, subBuilder);
            }
            return subBuilder;
        }
    }

    public static class Result<T> {
        private final T result;
        private final Map<String, String> rawParameters;

        public Result(T result, Map<String, String> rawParameters) {
            this.result = result;
            this.rawParameters = rawParameters;
        }

        public T getResult() {
            return this.result;
        }

        public Map<String, String> getRawParameters() {
            return this.rawParameters;
        }
    }
}

