/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.request;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.auth.EndpointsAuthenticator;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.request.Attribute;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Function;
import endpoints.repackaged.com.google.common.base.Predicates;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class Auth {
    private static final Logger logger = Logger.getLogger(Auth.class.getName());
    private static volatile Map<Class<? extends Authenticator>, Authenticator> authenticatorInstances = new HashMap<Class<? extends Authenticator>, Authenticator>();
    private static final Authenticator DEFAULT_AUTHENTICATOR = new EndpointsAuthenticator();
    private static final Function<Class<? extends Authenticator>, Authenticator> INSTANTIATE_AUTHENTICATOR = new Function<Class<? extends Authenticator>, Authenticator>(){

        @Override
        public Authenticator apply(Class<? extends Authenticator> clazz) {
            try {
                if (clazz.getAnnotation(Singleton.class) != null) {
                    if (!authenticatorInstances.containsKey(clazz)) {
                        authenticatorInstances.put(clazz, clazz.newInstance());
                    }
                    return (Authenticator)authenticatorInstances.get(clazz);
                }
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.log(Level.WARNING, "Could not instantiate  authenticator: " + clazz.getName());
                return null;
            }
        }
    };
    private final HttpServletRequest request;
    private final Attribute attr;
    private final ApiMethodConfig config;

    @VisibleForTesting
    Auth(HttpServletRequest request) {
        this.request = request;
        this.attr = Attribute.from(request);
        this.config = (ApiMethodConfig)this.attr.get("endpoints:Api-Method-Config");
    }

    static Auth from(HttpServletRequest request) {
        return new Auth(request);
    }

    @VisibleForTesting
    Iterable<Authenticator> getAuthenticatorInstances() {
        List<Class<? extends Authenticator>> classes = this.config.getAuthenticators();
        return classes == null ? ImmutableList.of(DEFAULT_AUTHENTICATOR) : Iterables.filter(Iterables.transform(classes, INSTANTIATE_AUTHENTICATOR), Predicates.notNull());
    }

    User authenticate() throws ServiceException {
        User user;
        block1: {
            Authenticator authenticator;
            Iterable<Authenticator> authenticators = this.getAuthenticatorInstances();
            user = null;
            if (authenticators == null) break block1;
            Iterator<Authenticator> iterator = authenticators.iterator();
            while (iterator.hasNext() && (user = (authenticator = iterator.next()).authenticate(this.request)) == null) {
            }
        }
        return user;
    }

    com.google.appengine.api.users.User authenticateAppEngineUser() throws ServiceException {
        if (!EnvUtil.isRunningOnAppEngine()) {
            return null;
        }
        this.attr.set("endpoints:Require-AppEngine-User", true);
        User user = this.authenticate();
        this.attr.set("endpoints:Require-AppEngine-User", false);
        if (user == null) {
            return null;
        }
        com.google.appengine.api.users.User appEngineUser = (com.google.appengine.api.users.User)this.attr.get("endpoints:Authenticated-AppEngine-User");
        if (appEngineUser != null) {
            return appEngineUser;
        }
        return user.getEmail() == null ? null : new com.google.appengine.api.users.User(user.getEmail(), "", user.getId());
    }
}

