/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import endpoints.repackaged.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;

public class EndpointsPrettyPrinter
extends DefaultPrettyPrinter {
    public EndpointsPrettyPrinter() {
        this(1);
    }

    public EndpointsPrettyPrinter(int spacesPerIndent) {
        SpaceIndenter indenter = new SpaceIndenter(spacesPerIndent);
        this.indentArraysWith(indenter);
        this.indentObjectsWith(indenter);
    }

    @Override
    public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
        jg.writeRaw(": ");
    }

    @Override
    public EndpointsPrettyPrinter createInstance() {
        return this;
    }

    private static class SpaceIndenter
    implements DefaultPrettyPrinter.Indenter {
        private final String indent;

        SpaceIndenter(int spacesPerIndent) {
            StringBuilder builder = new StringBuilder(spacesPerIndent);
            for (int i = 0; i < spacesPerIndent; ++i) {
                builder.append(' ');
            }
            this.indent = builder.toString();
        }

        @Override
        public void writeIndentation(JsonGenerator jg, int level) throws IOException {
            jg.writeRaw('\n');
            for (int i = 0; i < level; ++i) {
                jg.writeRaw(this.indent);
            }
        }

        @Override
        public boolean isInline() {
            return false;
        }
    }
}

