/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import com.google.api.server.spi.ServiceException;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class UnauthorizedException
extends ServiceException {
    public static final String AUTH_SCHEME_BEARER = "Bearer";
    private static final Map<String, String> GOOGLE_REALM = ImmutableMap.of("realm", "\"https://accounts.google.com/\"");
    private static final int CODE = 401;
    private final String authScheme;
    private final Map<String, String> params;

    public UnauthorizedException(String message) {
        this(message, AUTH_SCHEME_BEARER, GOOGLE_REALM);
    }

    public UnauthorizedException(Throwable cause) {
        super(401, cause);
        this.authScheme = AUTH_SCHEME_BEARER;
        this.params = GOOGLE_REALM;
    }

    public UnauthorizedException(String message, Throwable cause) {
        super(401, message, cause);
        this.authScheme = AUTH_SCHEME_BEARER;
        this.params = null;
    }

    public UnauthorizedException(String statusMessage, String reason) {
        super(401, statusMessage, reason);
        this.authScheme = AUTH_SCHEME_BEARER;
        this.params = null;
    }

    public UnauthorizedException(String statusMessage, String reason, Throwable cause) {
        super(401, statusMessage, reason, cause);
        this.authScheme = AUTH_SCHEME_BEARER;
        this.params = null;
    }

    public UnauthorizedException(String statusMessage, String reason, String domain) {
        super(401, statusMessage, reason, domain);
        this.authScheme = AUTH_SCHEME_BEARER;
        this.params = null;
    }

    public UnauthorizedException(String statusMessage, String reason, String domain, Throwable cause) {
        super(401, statusMessage, reason, domain, cause);
        this.authScheme = AUTH_SCHEME_BEARER;
        this.params = null;
    }

    public UnauthorizedException(String message, String authScheme, Map<String, String> params) {
        super(401, message);
        this.authScheme = authScheme;
        this.params = params;
    }

    public UnauthorizedException(String message, String reason, String domain, String authScheme, Map<String, String> params) {
        super(401, message, reason, domain, null);
        this.authScheme = authScheme;
        this.params = params;
    }

    @Override
    public Map<String, String> getHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        StringBuilder value = new StringBuilder(this.authScheme);
        if (this.params != null) {
            boolean first = true;
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    value.append(',');
                }
                value.append(' ');
                value.append(entry.getKey());
                value.append('=');
                value.append(entry.getValue());
            }
        }
        headers.put("WWW-Authenticate", value.toString());
        return headers;
    }
}

