/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.databind.ser.std;

import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonFormat;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import endpoints.repackaged.com.fasterxml.jackson.databind.AnnotationIntrospector;
import endpoints.repackaged.com.fasterxml.jackson.databind.BeanProperty;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonMappingException;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonSerializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializationFeature;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializerProvider;
import endpoints.repackaged.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;

public abstract class ArraySerializerBase<T>
extends ContainerSerializer<T>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final Boolean _unwrapSingle;

    protected ArraySerializerBase(Class<T> cls) {
        super(cls);
        this._property = null;
        this._unwrapSingle = null;
    }

    @Deprecated
    protected ArraySerializerBase(Class<T> cls, BeanProperty property) {
        super(cls);
        this._property = property;
        this._unwrapSingle = null;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src) {
        super(src._handledType, false);
        this._property = src._property;
        this._unwrapSingle = src._unwrapSingle;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property, Boolean unwrapSingle) {
        super(src._handledType, false);
        this._property = property;
        this._unwrapSingle = unwrapSingle;
    }

    @Deprecated
    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property) {
        super(src._handledType, false);
        this._property = property;
        this._unwrapSingle = src._unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector intr;
        JsonFormat.Value format;
        Boolean unwrapSingle = null;
        if (property != null && (format = property.findFormatOverrides(intr = provider.getAnnotationIntrospector())) != null && (unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) != this._unwrapSingle) {
            return this._withResolved(property, unwrapSingle);
        }
        return this;
    }

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if ((this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE) && this.hasSingleElement(value)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray();
        gen.setCurrentValue(value);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public final void serializeWithType(T value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForArray(value, gen);
        gen.setCurrentValue(value);
        this.serializeContents(value, gen, provider);
        typeSer.writeTypeSuffixForArray(value, gen);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;
}

