/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.databind.ser.std;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import endpoints.repackaged.com.fasterxml.jackson.databind.JavaType;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonMappingException;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonNode;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonSerializable;
import endpoints.repackaged.com.fasterxml.jackson.databind.ObjectMapper;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializerProvider;
import endpoints.repackaged.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import endpoints.repackaged.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import endpoints.repackaged.com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import endpoints.repackaged.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.node.ObjectNode;
import endpoints.repackaged.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;

@JacksonStdImpl
public class SerializableSerializer
extends StdSerializer<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();
    private static final AtomicReference<ObjectMapper> _mapperReference = new AtomicReference();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers, JsonSerializable value) {
        if (value instanceof JsonSerializable.Base) {
            return ((JsonSerializable.Base)value).isEmpty(serializers);
        }
        return false;
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        value.serialize(gen, serializers);
    }

    @Override
    public final void serializeWithType(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        value.serializeWithType(gen, serializers, typeSer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.rawClass(typeHint)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.set("properties", SerializableSerializer._getObjectMapper().readTree(objectProperties));
            }
            catch (IOException e) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaObjectPropertiesDefinition value");
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.set("items", SerializableSerializer._getObjectMapper().readTree(itemDefinition));
            }
            catch (IOException e) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaItemDefinition value");
            }
        }
        return objectNode;
    }

    private static final synchronized ObjectMapper _getObjectMapper() {
        ObjectMapper mapper = _mapperReference.get();
        if (mapper == null) {
            mapper = new ObjectMapper();
            _mapperReference.set(mapper);
        }
        return mapper;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }
}

