/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.datatype.joda.deser;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonParser;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonProcessingException;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonToken;
import endpoints.repackaged.com.fasterxml.jackson.databind.DeserializationContext;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import endpoints.repackaged.org.joda.time.DateMidnight;
import endpoints.repackaged.org.joda.time.LocalDate;
import endpoints.repackaged.org.joda.time.format.DateTimeFormatter;
import endpoints.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.IOException;

public class DateMidnightDeserializer
extends JodaDeserializerBase<DateMidnight> {
    private static final long serialVersionUID = 1L;
    static final DateTimeFormatter parser = ISODateTimeFormat.localDateParser();

    public DateMidnightDeserializer() {
        super(DateMidnight.class);
    }

    @Override
    public DateMidnight deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.isExpectedStartArrayToken()) {
            jp.nextToken();
            int year = jp.getIntValue();
            jp.nextToken();
            int month = jp.getIntValue();
            jp.nextToken();
            int day = jp.getIntValue();
            if (jp.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "after DateMidnight ints");
            }
            return new DateMidnight(year, month, day);
        }
        switch (jp.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return new DateMidnight(jp.getLongValue());
            }
            case VALUE_STRING: {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                LocalDate local = parser.parseLocalDate(str);
                if (local == null) {
                    return null;
                }
                return local.toDateMidnight();
            }
        }
        throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }
}

