/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.datatype.joda.deser;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonParser;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonProcessingException;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonToken;
import endpoints.repackaged.com.fasterxml.jackson.databind.DeserializationContext;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import endpoints.repackaged.org.joda.time.Instant;
import java.io.IOException;

public class InstantDeserializer
extends JodaDeserializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantDeserializer() {
        super(Instant.class);
    }

    @Override
    public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Instant(jp.getLongValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            return new Instant(str);
        }
        throw ctxt.mappingException(Instant.class);
    }
}

