/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.datatype.joda.deser;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonParser;
import endpoints.repackaged.com.fasterxml.jackson.databind.DeserializationContext;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonNode;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import endpoints.repackaged.org.joda.time.Days;
import endpoints.repackaged.org.joda.time.Hours;
import endpoints.repackaged.org.joda.time.Minutes;
import endpoints.repackaged.org.joda.time.Months;
import endpoints.repackaged.org.joda.time.ReadablePeriod;
import endpoints.repackaged.org.joda.time.Seconds;
import endpoints.repackaged.org.joda.time.Weeks;
import endpoints.repackaged.org.joda.time.Years;
import java.io.IOException;

public class ReadablePeriodDeserializer
extends JodaDeserializerBase<ReadablePeriod> {
    private static final long serialVersionUID = 1L;

    public ReadablePeriodDeserializer() {
        super(ReadablePeriod.class);
    }

    @Override
    public ReadablePeriod deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode treeNode = (JsonNode)jsonParser.readValueAsTree();
        String periodType = treeNode.path("fieldType").path("name").asText();
        String periodName = treeNode.path("periodType").path("name").asText();
        int periodValue = treeNode.path(periodType).asInt();
        if (periodName.equals("Seconds")) {
            return Seconds.seconds(periodValue);
        }
        if (periodName.equals("Minutes")) {
            return Minutes.minutes(periodValue);
        }
        if (periodName.equals("Hours")) {
            return Hours.hours(periodValue);
        }
        if (periodName.equals("Days")) {
            return Days.days(periodValue);
        }
        if (periodName.equals("Weeks")) {
            return Weeks.weeks(periodValue);
        }
        if (periodName.equals("Months")) {
            return Months.months(periodValue);
        }
        if (periodName.equals("Years")) {
            return Years.years(periodValue);
        }
        throw ctxt.mappingException("Don't know how to deserialize ReadablePeriod using periodName '" + periodName + "'");
    }
}

