/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.datatype.joda.ser;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerationException;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonNode;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializerProvider;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import endpoints.repackaged.org.joda.time.DateTime;
import endpoints.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.IOException;
import java.lang.reflect.Type;

public final class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(ISODateTimeFormat.dateTime().withZoneUTC());

    public DateTimeSerializer() {
        this(DEFAULT_FORMAT);
    }

    public DateTimeSerializer(JacksonJodaFormat format) {
        super(DateTime.class, format);
    }

    public DateTimeSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new DateTimeSerializer(formatter);
    }

    @Override
    public void serialize(DateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeNumber(value.getMillis());
        } else {
            jgen.writeString(this._format.createFormatter(provider).print(value));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "number" : "string", true);
    }
}

