/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.fasterxml.jackson.datatype.joda.ser;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerationException;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonNode;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializerProvider;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import endpoints.repackaged.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import endpoints.repackaged.org.joda.time.LocalTime;
import java.io.IOException;
import java.lang.reflect.Type;

public final class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(DEFAULT_TIMEONLY_FORMAT);

    public LocalTimeSerializer() {
        this(DEFAULT_FORMAT);
    }

    public LocalTimeSerializer(JacksonJodaFormat format) {
        super(LocalTime.class, format);
    }

    public LocalTimeSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new LocalTimeSerializer(formatter);
    }

    @Override
    public void serialize(LocalTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.hourOfDay().get());
            jgen.writeNumber(value.minuteOfHour().get());
            jgen.writeNumber(value.secondOfMinute().get());
            jgen.writeNumber(value.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print(value));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "array" : "string", true);
    }
}

