/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.client.auth.oauth2;

import endpoints.repackaged.com.google.api.client.auth.oauth2.Credential;
import endpoints.repackaged.com.google.api.client.auth.oauth2.CredentialRefreshListener;
import endpoints.repackaged.com.google.api.client.auth.oauth2.StoredCredential;
import endpoints.repackaged.com.google.api.client.auth.oauth2.TokenErrorResponse;
import endpoints.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import endpoints.repackaged.com.google.api.client.util.Beta;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import endpoints.repackaged.com.google.api.client.util.store.DataStore;
import endpoints.repackaged.com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class DataStoreCredentialRefreshListener
implements CredentialRefreshListener {
    private final DataStore<StoredCredential> credentialDataStore;
    private final String userId;

    public DataStoreCredentialRefreshListener(String userId, DataStoreFactory dataStoreFactory) throws IOException {
        this(userId, StoredCredential.getDefaultDataStore(dataStoreFactory));
    }

    public DataStoreCredentialRefreshListener(String userId, DataStore<StoredCredential> credentialDataStore) {
        this.userId = Preconditions.checkNotNull(userId);
        this.credentialDataStore = Preconditions.checkNotNull(credentialDataStore);
    }

    @Override
    public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
        this.makePersistent(credential);
    }

    @Override
    public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
        this.makePersistent(credential);
    }

    public DataStore<StoredCredential> getCredentialDataStore() {
        return this.credentialDataStore;
    }

    public void makePersistent(Credential credential) throws IOException {
        this.credentialDataStore.set(this.userId, new StoredCredential(credential));
    }
}

