/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.client.googleapis.compute;

import endpoints.repackaged.com.google.api.client.auth.oauth2.BearerToken;
import endpoints.repackaged.com.google.api.client.auth.oauth2.Credential;
import endpoints.repackaged.com.google.api.client.auth.oauth2.CredentialRefreshListener;
import endpoints.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import endpoints.repackaged.com.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import endpoints.repackaged.com.google.api.client.http.GenericUrl;
import endpoints.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import endpoints.repackaged.com.google.api.client.http.HttpRequest;
import endpoints.repackaged.com.google.api.client.http.HttpRequestInitializer;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.json.JsonFactory;
import endpoints.repackaged.com.google.api.client.json.JsonObjectParser;
import endpoints.repackaged.com.google.api.client.util.Beta;
import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collection;

@Beta
public class ComputeCredential
extends Credential {
    public static final String TOKEN_SERVER_ENCODED_URL = String.valueOf(OAuth2Utils.getMetadataServerUrl()).concat("/computeMetadata/v1/instance/service-accounts/default/token");

    public ComputeCredential(HttpTransport transport, JsonFactory jsonFactory) {
        this(new Builder(transport, jsonFactory));
    }

    protected ComputeCredential(Builder builder) {
        super(builder);
    }

    protected TokenResponse executeRefreshToken() throws IOException {
        GenericUrl tokenUrl = new GenericUrl(this.getTokenServerEncodedUrl());
        HttpRequest request = this.getTransport().createRequestFactory().buildGetRequest(tokenUrl);
        request.setParser(new JsonObjectParser(this.getJsonFactory()));
        request.getHeaders().set("Metadata-Flavor", "Google");
        return request.execute().parseAs(TokenResponse.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static class Builder
    extends Credential.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory) {
            super(BearerToken.authorizationHeaderAccessMethod());
            this.setTransport(transport);
            this.setJsonFactory(jsonFactory);
            this.setTokenServerEncodedUrl(TOKEN_SERVER_ENCODED_URL);
        }

        @Override
        public ComputeCredential build() {
            return new ComputeCredential(this);
        }

        @Override
        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(Preconditions.checkNotNull(transport));
        }

        @Override
        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        @Override
        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(Preconditions.checkNotNull(jsonFactory));
        }

        @Override
        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl(Preconditions.checkNotNull(tokenServerUrl));
        }

        @Override
        public Builder setTokenServerEncodedUrl(String tokenServerEncodedUrl) {
            return (Builder)super.setTokenServerEncodedUrl(Preconditions.checkNotNull(tokenServerEncodedUrl));
        }

        @Override
        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            Preconditions.checkArgument(clientAuthentication == null);
            return this;
        }

        @Override
        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        @Override
        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            return (Builder)super.addRefreshListener(refreshListener);
        }

        @Override
        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            return (Builder)super.setRefreshListeners(refreshListeners);
        }
    }
}

