/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.client.http;

import endpoints.repackaged.com.google.api.client.http.HttpIOExceptionHandler;
import endpoints.repackaged.com.google.api.client.http.HttpRequest;
import endpoints.repackaged.com.google.api.client.util.BackOff;
import endpoints.repackaged.com.google.api.client.util.BackOffUtils;
import endpoints.repackaged.com.google.api.client.util.Beta;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import endpoints.repackaged.com.google.api.client.util.Sleeper;
import java.io.IOException;

@Beta
public class HttpBackOffIOExceptionHandler
implements HttpIOExceptionHandler {
    private final BackOff backOff;
    private Sleeper sleeper = Sleeper.DEFAULT;

    public HttpBackOffIOExceptionHandler(BackOff backOff) {
        this.backOff = Preconditions.checkNotNull(backOff);
    }

    public final BackOff getBackOff() {
        return this.backOff;
    }

    public final Sleeper getSleeper() {
        return this.sleeper;
    }

    public HttpBackOffIOExceptionHandler setSleeper(Sleeper sleeper) {
        this.sleeper = Preconditions.checkNotNull(sleeper);
        return this;
    }

    public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
        if (!supportsRetry) {
            return false;
        }
        try {
            return BackOffUtils.next(this.sleeper, this.backOff);
        }
        catch (InterruptedException exception) {
            return false;
        }
    }
}

