/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.common.graph;

import endpoints.repackaged.com.google.common.annotations.Beta;
import endpoints.repackaged.com.google.common.base.Function;
import endpoints.repackaged.com.google.common.base.Functions;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.graph.AbstractGraphBuilder;
import endpoints.repackaged.com.google.common.graph.ConfigurableValueGraph;
import endpoints.repackaged.com.google.common.graph.DirectedGraphConnections;
import endpoints.repackaged.com.google.common.graph.ForwardingGraph;
import endpoints.repackaged.com.google.common.graph.Graph;
import endpoints.repackaged.com.google.common.graph.GraphBuilder;
import endpoints.repackaged.com.google.common.graph.GraphConnections;
import endpoints.repackaged.com.google.common.graph.GraphConstants;
import endpoints.repackaged.com.google.common.graph.UndirectedGraphConnections;
import endpoints.repackaged.com.google.common.graph.ValueGraph;

@Beta
public abstract class ImmutableGraph<N>
extends ForwardingGraph<N> {
    ImmutableGraph() {
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ValueBackedImpl<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size());
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    static class ValueBackedImpl<N, V>
    extends ImmutableGraph<N> {
        protected final ValueGraph<N, V> backingValueGraph;

        ValueBackedImpl(AbstractGraphBuilder<? super N> builder, ImmutableMap<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
            this.backingValueGraph = new ConfigurableValueGraph<N, V>(builder, nodeConnections, edgeCount);
        }

        @Override
        protected Graph<N> delegate() {
            return this.backingValueGraph;
        }
    }
}

