/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.io.swagger.models;

import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonIgnore;
import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonProperty;
import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import endpoints.repackaged.io.swagger.models.AbstractModel;
import endpoints.repackaged.io.swagger.models.Xml;
import endpoints.repackaged.io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"type", "required", "discriminator", "properties"})
@JsonPropertyOrder(value={"type", "required", "discriminator", "properties"})
public class ModelImpl
extends AbstractModel {
    public static final String OBJECT = "object";
    private String type;
    private String format;
    private String name;
    private List<String> required;
    private Map<String, Property> properties;
    private boolean isSimple = false;
    private String description;
    private Object example;
    private Property additionalProperties;
    private String discriminator;
    private Xml xml;
    @JsonProperty(value="default")
    private String defaultValue;
    private List<String> _enum;

    public ModelImpl _enum(List<String> value) {
        this._enum = value;
        return this;
    }

    public ModelImpl _enum(String value) {
        if (this._enum == null) {
            this._enum = new ArrayList<String>();
        }
        this._enum.add(value);
        return this;
    }

    public List<String> getEnum() {
        return this._enum;
    }

    public void setEnum(List<String> _enum) {
        this._enum = _enum;
    }

    public ModelImpl discriminator(String discriminator) {
        this.setDiscriminator(discriminator);
        return this;
    }

    public ModelImpl type(String type) {
        this.setType(type);
        return this;
    }

    public ModelImpl format(String format) {
        this.setFormat(format);
        return this;
    }

    public ModelImpl name(String name) {
        this.setName(name);
        return this;
    }

    public ModelImpl description(String description) {
        this.setDescription(description);
        return this;
    }

    public ModelImpl property(String key, Property property) {
        this.addProperty(key, property);
        return this;
    }

    public ModelImpl example(Object example) {
        this.setExample(example);
        return this;
    }

    public ModelImpl additionalProperties(Property additionalProperties) {
        this.setAdditionalProperties(additionalProperties);
        return this;
    }

    public ModelImpl required(String name) {
        this.addRequired(name);
        return this;
    }

    public ModelImpl xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public Property getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Property additionalProperties) {
        this.type(OBJECT);
        this.additionalProperties = additionalProperties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addRequired(String name) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(name);
        Property p = this.properties.get(name);
        if (p != null) {
            p.setRequired(true);
        }
    }

    public List<String> getRequired() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                Property prop = this.properties.get(key);
                if (prop == null || !prop.getRequired()) continue;
                output.add(key);
            }
        }
        Collections.sort(output);
        if (output.size() > 0) {
            return output;
        }
        return null;
    }

    public void setRequired(List<String> required) {
        this.required = required;
        if (this.properties != null) {
            for (String s : required) {
                Property p = this.properties.get(s);
                if (p == null) continue;
                p.setRequired(true);
            }
        }
    }

    public void addProperty(String key, Property property) {
        if (property == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        if (this.required != null) {
            for (String ek : this.required) {
                if (!key.equals(ek)) continue;
                property.setRequired(true);
            }
        }
        this.properties.put(key, property);
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                this.addProperty(key, properties.get(key));
            }
        }
    }

    @Override
    public Object getExample() {
        if (this.example == null) {
            // empty if block
        }
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    public Xml getXml() {
        return this.xml;
    }

    public void setXml(Xml xml) {
        this.xml = xml;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Object clone() {
        ModelImpl cloned = new ModelImpl();
        super.cloneTo(cloned);
        cloned.type = this.type;
        cloned.name = this.name;
        cloned.required = this.required;
        cloned.properties = this.properties;
        cloned.isSimple = this.isSimple;
        cloned.description = this.description;
        cloned.example = this.example;
        cloned.additionalProperties = this.additionalProperties;
        cloned.discriminator = this.discriminator;
        cloned.xml = this.xml;
        cloned.defaultValue = this.defaultValue;
        return cloned;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.discriminator == null ? 0 : this.discriminator.hashCode());
        result = 31 * result + (this.example == null ? 0 : this.example.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.isSimple ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.required == null ? 0 : this.required.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.xml == null ? 0 : this.xml.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelImpl other = (ModelImpl)obj;
        if (this.additionalProperties == null ? other.additionalProperties != null : !this.additionalProperties.equals(other.additionalProperties)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.discriminator == null ? other.discriminator != null : !this.discriminator.equals(other.discriminator)) {
            return false;
        }
        if (this.example == null ? other.example != null : !this.example.equals(other.example)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.isSimple != other.isSimple) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.required == null ? other.required != null : !this.required.equals(other.required)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.xml == null ? other.xml != null : !this.xml.equals(other.xml)) {
            return false;
        }
        return !(this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue));
    }
}

