/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.io.swagger.models.refs;

import endpoints.repackaged.io.swagger.models.refs.RefFormat;
import endpoints.repackaged.io.swagger.models.refs.RefType;

public class GenericRef {
    private final RefFormat format;
    private final RefType type;
    private final String ref;
    private final String simpleRef;

    public GenericRef(RefType type, String ref) {
        this.format = GenericRef.computeRefFormat(ref);
        this.type = type;
        this.ref = this.format == RefFormat.INTERNAL && !ref.startsWith("#/") ? type.getInternalPrefix() + ref : ref;
        this.simpleRef = GenericRef.computeSimpleRef(this.ref, this.format, type);
    }

    public RefFormat getFormat() {
        return this.format;
    }

    public RefType getType() {
        return this.type;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSimpleRef() {
        return this.simpleRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericRef that = (GenericRef)o;
        if (this.format != that.format) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        return !(this.simpleRef == null ? that.simpleRef != null : !this.simpleRef.equals(that.simpleRef));
    }

    public int hashCode() {
        int result = this.format != null ? this.format.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 31 * result + (this.simpleRef != null ? this.simpleRef.hashCode() : 0);
        return result;
    }

    private static String computeSimpleRef(String ref, RefFormat format, RefType type) {
        String result = ref;
        if (format == RefFormat.INTERNAL) {
            String prefix = type.getInternalPrefix();
            result = ref.substring(prefix.length());
        }
        return result;
    }

    private static RefFormat computeRefFormat(String ref) {
        RefFormat result = RefFormat.INTERNAL;
        if (ref.startsWith("http")) {
            result = RefFormat.URL;
        } else if (ref.startsWith("#/")) {
            result = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/")) {
            result = RefFormat.RELATIVE;
        }
        return result;
    }
}

