/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.io.swagger.util;

import endpoints.repackaged.com.fasterxml.jackson.core.JsonParser;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonProcessingException;
import endpoints.repackaged.com.fasterxml.jackson.databind.DeserializationContext;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonDeserializer;
import endpoints.repackaged.com.fasterxml.jackson.databind.JsonNode;
import endpoints.repackaged.com.fasterxml.jackson.databind.node.TextNode;
import endpoints.repackaged.io.swagger.models.ArrayModel;
import endpoints.repackaged.io.swagger.models.ComposedModel;
import endpoints.repackaged.io.swagger.models.Model;
import endpoints.repackaged.io.swagger.models.ModelImpl;
import endpoints.repackaged.io.swagger.models.RefModel;
import endpoints.repackaged.io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelDeserializer
extends JsonDeserializer<Model> {
    @Override
    public Model deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub = node.get("$ref");
        JsonNode allOf = node.get("allOf");
        if (sub != null) {
            return Json.mapper().convertValue((Object)sub, RefModel.class);
        }
        if (allOf != null) {
            ComposedModel model = null;
            model = Json.mapper().convertValue((Object)node, ComposedModel.class);
            List<Model> allComponents = model.getAllOf();
            if (allComponents.size() >= 1) {
                model.setParent(allComponents.get(0));
                if (allComponents.size() >= 2) {
                    model.setChild(allComponents.get(allComponents.size() - 1));
                    ArrayList<RefModel> interfaces = new ArrayList<RefModel>();
                    int size = allComponents.size();
                    for (Model m : allComponents.subList(1, size - 1)) {
                        if (!(m instanceof RefModel)) continue;
                        RefModel ref = (RefModel)m;
                        interfaces.add(ref);
                    }
                    model.setInterfaces(interfaces);
                } else {
                    model.setChild(new ModelImpl());
                }
            }
            return model;
        }
        sub = node.get("type");
        Model model = null;
        model = sub != null && "array".equals(((TextNode)sub).textValue()) ? (Model)Json.mapper().convertValue((Object)node, ArrayModel.class) : (Model)Json.mapper().convertValue((Object)node, ModelImpl.class);
        return model;
    }
}

