/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.io.swagger.util;

import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonInclude;
import endpoints.repackaged.com.fasterxml.jackson.core.JsonFactory;
import endpoints.repackaged.com.fasterxml.jackson.databind.DeserializationFeature;
import endpoints.repackaged.com.fasterxml.jackson.databind.ObjectMapper;
import endpoints.repackaged.com.fasterxml.jackson.databind.SerializationFeature;
import endpoints.repackaged.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import endpoints.repackaged.io.swagger.util.DeserializationModule;

public class ObjectMapperFactory {
    protected static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    protected static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(null, includePathDeserializer, includeResponseDeserializer);
    }

    protected static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    protected static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(new YAMLFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    private static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = jsonFactory == null ? new ObjectMapper() : new ObjectMapper(jsonFactory);
        DeserializationModule deserializerModule = new DeserializationModule(includePathDeserializer, includeResponseDeserializer);
        mapper.registerModule(deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

