/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.client.protocol;

import endpoints.repackaged.org.apache.commons.logging.Log;
import endpoints.repackaged.org.apache.commons.logging.LogFactory;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpRequest;
import endpoints.repackaged.org.apache.http.HttpRequestInterceptor;
import endpoints.repackaged.org.apache.http.annotation.Immutable;
import endpoints.repackaged.org.apache.http.auth.AuthScheme;
import endpoints.repackaged.org.apache.http.auth.AuthState;
import endpoints.repackaged.org.apache.http.auth.AuthenticationException;
import endpoints.repackaged.org.apache.http.auth.Credentials;
import endpoints.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestTargetAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block10: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            String method = request.getRequestLine().getMethod();
            if (method.equalsIgnoreCase("CONNECT")) {
                return;
            }
            if (request.containsHeader("Authorization")) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState == null) {
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    request.addHeader(authScheme.authenticate(creds, request));
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error("Authentication error: " + ex.getMessage());
                }
            }
        }
    }
}

