/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.auth;

import endpoints.repackaged.org.apache.commons.codec.binary.Base64;
import endpoints.repackaged.org.apache.http.Header;
import endpoints.repackaged.org.apache.http.HttpRequest;
import endpoints.repackaged.org.apache.http.annotation.NotThreadSafe;
import endpoints.repackaged.org.apache.http.auth.AuthenticationException;
import endpoints.repackaged.org.apache.http.auth.Credentials;
import endpoints.repackaged.org.apache.http.auth.MalformedChallengeException;
import endpoints.repackaged.org.apache.http.auth.params.AuthParams;
import endpoints.repackaged.org.apache.http.impl.auth.RFC2617Scheme;
import endpoints.repackaged.org.apache.http.message.BufferedHeader;
import endpoints.repackaged.org.apache.http.util.CharArrayBuffer;
import endpoints.repackaged.org.apache.http.util.EncodingUtils;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private boolean complete = false;

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String charset = AuthParams.getCredentialCharset(request.getParams());
        return BasicScheme.authenticate(credentials, charset, this.isProxy());
    }

    public static Header authenticate(Credentials credentials, String charset, boolean proxy) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset may not be null");
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (proxy) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }
}

